#ifndef __ELEMENT_H_INCLUDED
#define __ELEMENT_H_INCLUDED 1

#include <string>
#include <list>
#include <map>
#include <boost/shared_ptr.hpp>

namespace RUNES {


class Element {
public:
	Element(const std::string& name);
	~Element();
public:
	typedef std::list<Element>			list_type;
	typedef list_type::iterator			iterator;
	typedef list_type::reverse_iterator		reverse_iterator;
	typedef list_type::const_iterator		const_iterator;
	typedef list_type::const_reverse_iterator	const_reverse_iterator;

	typedef std::list<std::string>			texts_type;
	typedef std::map<std::string, std::string>	attributes_type;
public:
	const std::string& getName(void) const;

	Element& appendChild(const Element& newChild);
	      list_type& getChildren(void);
	const list_type& getChildren(void) const;
	const_iterator getFirstChildByName(const std::string& name) const;
	const_reverse_iterator getLastChildByName(const std::string& name) const;

	void appendAttribute(const std::string& name, const std::string& value);
	const attributes_type& getAttributes(void) const;

	void appendText(const std::string& text);
	const bool hasText(void) const;
	const texts_type& getTexts(void) const;
	const std::string getConnectedText(void) const;

	void clear(void);

	iterator begin(void)				{ return m_children.begin();	}
	iterator end(void)				{ return m_children.end();	}
	reverse_iterator rbegin(void)			{ return m_children.rbegin();	}
	reverse_iterator rend(void)			{ return m_children.rend();	}
	const_iterator begin(void) const		{ return m_children.begin();	}
	const_iterator end(void) const			{ return m_children.end();	}
	const_reverse_iterator rbegin(void) const	{ return m_children.rbegin();	}
	const_reverse_iterator rend(void) const		{ return m_children.rend();	}
public:
	// for debug
	void show(const std::string& head = "") const;
private:
	std::string	m_name;
	list_type	m_children;
	attributes_type	m_attributes;
	texts_type	m_texts;
private:
	Element();
};


}  // namespace RUNES

#endif /* element.h */
