#ifndef __BUNDLE_PARSER_H_INCLUDED
#define __BUNDLE_PARSER_H_INCLUDED 1

#include "sax.h"
#include "bundle_depend.h"
#include "element.h"
#include <deque>

namespace RUNES {


class BundleInfo;
class BundleParser {
public:
	BundleParser(const Element& document, BundleInfo* result);
	~BundleParser();
public:
	void parse(void);
private:
	const Element& m_document;
	BundleInfo* m_result;
};

#if 0
class BundleParser : public SAX {
public:
	BundleParser(std::istream& source_stream, BundleInfo* result);
	~BundleParser();
private:
	void initializer(void);
	void finalizer(void);
	void startElementHandler(const std::string& name, const attributes_t& attributes);
	void endElementHandler(const std::string& name);
	void textHandler(const std::string& text);
	void errorHandler(const std::string& message, unsigned long long line, unsigned long long column);
private:
	const std::string& getTopElement(void) const;
	const std::string& getBottomElement(void) const;

	// dependency parser
	void startDependLogicAND(const attributes_t& attributes);
	void startDependLogicOR(const attributes_t& attributes);
	void endDependLogicAND(void);
	void endDependLogicOR(void);
	void startDependContext(const std::string& text);
private:
	// parsing context
	std::deque<std::string> m_path;
	attributes_t m_current_atts;
	std::deque<BDLogic*> m_logic_path;
	BDLogicAND m_depend;

	// parsed result
	BundleInfo* m_result;
private:
	std::list<std::string> getAttrValue(const std::string& key) const;
};
#endif


}  // namespace RUNES

#endif /* bundle_parser.h */
