#include "bundle_info.h"
#include "bundle_parser.h"
#include "sax_to_dom.h"

#include <iostream>

namespace RUNES {


// コンストラクタ
BundleInfo::BundleInfo() {}


// デストラクタ
BundleInfo::~BundleInfo() {}


// public:
const std::string& BundleInfo::getName(void)     const
{ return m_name;    }

const Version&     BundleInfo::getVersion(void) const
{ return m_version; }

const std::string& BundleInfo::getRelease(void) const
{ return m_release; }

const std::string& BundleInfo::getArch(void)    const
{ return m_arch;    }

const BDLogicAND&  BundleInfo::getDepend(void)  const
{ return m_depend;  }


const std::list<std::string> BundleInfo::getPreOrder(void)  const
{
	std::list<std::string> order_list;
	m_depend.getRecursivePreOrder(&order_list);
	return order_list;
}

const std::list<std::string> BundleInfo::getPostOrder(void) const
{
	std::list<std::string> order_list;
	m_depend.getRecursivePostOrder(&order_list);
	return order_list;
}


void BundleInfo::show(void) const
{
	// XXX: 不十分
	std::cout << "Name: " << m_name << "\n";
	std::cout << "Version: " << m_version.str() << "\n";
	std::cout << "Release: " << m_release << "\n";
	std::cout << "Dependency: " << "\n";
	m_depend.show();
	std::cout << std::endl;
}



// コンストラクタ
BundleInfoHolder::BundleInfoHolder() {}


// デストラクタ
BundleInfoHolder::~BundleInfoHolder() {}


// public:
void BundleInfoHolder::parseInfo(std::istream& source_stream)
{
	Element document("BundleInfo");
	SAXtoDOM todom(source_stream, &document);
	todom.parse();
	BundleParser parser(document, &m_info);
	parser.parse();
}
void BundleInfoHolder::parseInfo(const Element& document)
{
	BundleParser parser(document, &m_info);
	parser.parse();
}


}  // namespace RUNES
