#include "bundle_depend.h"
#include <iostream>

namespace RUNES {


// showインターフェース
void BDLogicAND::show(void) const
{
	std::cout << "AND {" << "\n";
	for( entries_t::const_iterator it( getEntries().begin() );
			it != getEntries().end();
			++it ) {
		(*it)->show();
	}
	std::cout << "}" << std::endl;
}

void BDLogicOR::show(void) const
{
	std::cout << "OR  {" << "\n";
	for( entries_t::const_iterator it( getEntries().begin() );
			it != getEntries().end();
			++it ) {
		(*it)->show();
	}
	std::cout << "}" << std::endl;
}

void BDTBundle::show(void) const
{
	std::cout << "Bundle: " << m_name << std::endl;
	/* XXX 未実装:
	switch(m_order) {
	case ORDER_ANY:
		std::cout << " (order=any)";
		break;
	case ORDER_PRE:
		std::cout << " (order=pre)";
		break;
	case ORDER_POST:
		std::cout << " (order=post)";
		break;
	}
	*/
	std::cout << std::endl;
}

void BDTHostFile::show(void) const
{
	std::cout << "File: " << getName() << std::endl;
}

void BDTHostLib::show(void) const
{
	std::cout << "Lib: " << getName() << std::endl;
}

void BDTHostBin::show(void) const
{
	std::cout << "Bin: " << getName() << std::endl;
}




// BundleHoldableインターフェース
void BDLogic::getRecursivePreOrder( std::list<std::string>* order_list) const
{
	for(entries_t::const_iterator ent( m_entries.begin() );
			ent != m_entries.end();
			++ent ) {
		depend_type t = (*ent)->getType();
		if( t == DEP_AND || t == DEP_OR ) {
			BDLogic* logic = static_cast<BDLogic*>( (*ent).get() );
			logic->getRecursivePreOrder(order_list);
		} else if( t == DEP_BUNDLE ) {
			BDTBundle* bundle = static_cast<BDTBundle*>( (*ent).get() );
			if( bundle->getOrder() == BDTBundle::ORDER_PRE ) {
				order_list->push_back( bundle->getName() );
			}
		}
	}
}
void BDLogic::getRecursivePostOrder(std::list<std::string>* order_list) const
{
	for(entries_t::const_iterator ent( m_entries.begin() );
			ent != m_entries.end();
			++ent ) {
		depend_type t = (*ent)->getType();
		if( t == DEP_AND || t == DEP_OR ) {
			BDLogic* logic = static_cast<BDLogic*>( (*ent).get() );
			logic->getRecursivePostOrder(order_list);
		} else if( t == DEP_BUNDLE ) {
			BDTBundle* bundle = static_cast<BDTBundle*>( (*ent).get() );
			if( bundle->getOrder() == BDTBundle::ORDER_POST ) {
				order_list->push_back( bundle->getName() );
			}
		}
	}
}


}  // namespace RUNES
