#ifndef __BUNDLE_H_INCLUDED
#define __BUNDLE_H_INCLUDED 1

#include "bundle_info.h"
#include <string>

namespace RUNES {


class Bundle : public BundleInfoHolder {
public:
	explicit Bundle(const std::string& path);
	~Bundle();
public:
	void initialize(void);	// BundleInfoHolder::m_infoをbundle_parser.hでパース
public:
	const std::string& getPath(void) const;
	void show(void) const;
private:
	std::string m_path;
	bool m_have_defconf;
	bool m_have_resource_dir;
private:
	Bundle();
};


}  // namespace RUNES

#endif /* bundle.h */
