#include "bundle.h"
#include "runestree.h"
#include "exception.h"
#include <fstream>

#include <iostream>

namespace RUNES {


// コンストラクタ
Bundle::Bundle(const std::string& path) :
	m_path(path)
{}

// デストラクタ
Bundle::~Bundle()
{}


// public:
void Bundle::initialize(void)
{
	std::ifstream file( (m_path + "/" + BundleComponent::METADATA_FILE_NAME).c_str() );
	if( ! file.is_open() ) {
		// XXX:
		std::runtime_error( std::string("Can't open ") + m_path + "/" + BundleComponent::METADATA_FILE_NAME );
	}
	BundleInfoHolder::parseInfo(file);	// XXX: 例外は呼び出し元で
	file.close();   // parse()より前にcloseしてはいけない
}

const std::string& Bundle::getPath(void) const
{
	return m_path;
}

void Bundle::show(void) const
{
	std::cout << "Bundle " << m_path << std::endl;
	m_info.show();	// XXX:
}


}  // namespace RUNES
