/* macio.c: Probe for i2o audio and airport on Apple machines.
 * 
 * Copyright (C) 2002 Dan Burcaw <dburcaw@terrasoftsolutions.com>
 *           (C) 2002 Terra Soft Solutions, Inc.
 *           (C) 2003 Red Hat, Inc.
 *
 * Based on sbus.c
 * Copyright (C) 1998, 1999 Jakub Jelinek (jj@ultra.linux.cz)
 *           (C) 1999, 2000 Red Hat, Inc.
 * 
 * This software may be freely redistributed under the terms of the GNU
 * public license.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "macio.h"

static void macioFreeDevice( struct macioDevice *dev ) {
    freeDevice( (struct device *)dev);
}

static void macioWriteDevice( FILE *file, struct macioDevice *dev) {
    writeDevice(file, (struct device *) dev);
}

static int macioCompareDevice(struct macioDevice *dev1, struct macioDevice *dev2)
{
	        return compareDevice( (struct device *)dev1, (struct device *)dev2);
}

struct macioDevice *macioNewDevice( struct macioDevice *old ) {
    struct macioDevice *ret;

    ret = malloc( sizeof(struct macioDevice) );
    memset(ret, '\0', sizeof (struct macioDevice));
    ret=(struct macioDevice *)newDevice((struct device *)old,(struct device *)ret);
    ret->bus = BUS_MACIO;
    ret->newDevice = macioNewDevice;
    ret->freeDevice = macioFreeDevice;
    ret->writeDevice = macioWriteDevice;
    ret->compareDevice = macioCompareDevice;
    return ret;
}

#ifdef __powerpc__
#include "minifind.h"

/* given a class to probe, returns an array macio devices found which match */
/* all entries are malloc'd, so caller must free when done. Use          */
/* dev->freeDevice(dev) to free individual macioDevice's, since they 	 */
/* have internal elements which are malloc'd                             */

struct device *macioProbe( enum deviceClass probeClass, int probeFlags,
		    struct device *devlist) {
    // check for airport
    if (probeClass & CLASS_NETWORK) {
	struct macioDevice *airport;
	struct pathNode *n;
	int ret = 0;

	struct findNode *list = (struct findNode *) malloc(sizeof(struct findNode));
        list->result = (struct pathNode *) malloc(sizeof(struct pathNode));
	list->result->path = NULL;
	list->result->next = list->result;

	minifind("/proc/device-tree/aliases", "wireless", list);

	// Supported
	for (n = list->result->next; n != list->result; n = n->next)
	{
		if (n->path)
			ret = 1;
	}

	if (ret)
	{
		airport = macioNewDevice(NULL);
		airport->type = CLASS_NETWORK;
		airport->device = strdup("eth");
		airport->desc = strdup("Apple Airport");
		airport->driver = strdup("airport");
		airport->next = devlist;
		devlist = (struct device *)airport;
	}
    }
    if (probeClass & CLASS_AUDIO) {
	struct macioDevice *dmasound;

	struct pathNode *n;
	int ret = 0;

	struct findNode *list = (struct findNode *) malloc(sizeof(struct findNode));
        list->result = (struct pathNode *) malloc(sizeof(struct pathNode));
	list->result->path = NULL;
	list->result->next = list->result;

	minifind("/proc/device-tree/aliases", "sound", list);

	// Supported
	for (n = list->result->next; n != list->result; n = n->next)
	{
		if (n->path)
			ret = 1;
	}

	if (ret)
	{
		dmasound = macioNewDevice(NULL);
		dmasound->type = CLASS_AUDIO;
		dmasound->desc = strdup("Apple|DMASOUND");
		dmasound->driver = strdup("dmasound_pmac");
		dmasound->next = devlist;
		devlist = (struct device *)dmasound;
	}

    }
    return devlist;
}

#else

struct device *macioProbe( enum deviceClass probeClass, int probeFlags,
		    struct device *devlist ) {
    return devlist;
}

#endif
