//	VirtualDubMod - Video processing and capture application based on VirtualDub by Avery Lee
//	Copyright (C) 1998-2002 VirtualDubMod Developers
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//  Adapted from a sample by Todd Jeffreys

#ifndef f_STARWARS_H
#define f_STARWARS_H

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "openglwnd.h"
#include <stdlib.h>
#include <vector>

using namespace std;

class CError
{
public:
  CError() {;}
  ~CError() {;}
};

typedef struct _tagVECTOR
{
  float x;
  float y;
  float z;
} VECTOR,*LPVECTOR;

typedef struct _tagTDPOINT
{
  double x; 
  double y;
  double z;
} TDPOINT,*LPTDPOINT;

typedef struct _tagSTAR
{
  TDPOINT m_start;
  VECTOR speed;
  float m_curPos[3]; // a float[], so we can call glVertex3fv
  float m_fColor[3];
  float timeOffset;
} STAR,*LPSTAR;

#define NUMOBJECTS 5
#define EYE_Z 3.0f
#define MAX_TEXT 128

class CObject
{
public:
  CObject() ;
  virtual ~CObject() {;}
  virtual void Draw() = 0;
  
  float m_fAngle;
  float m_fTimeOffset;
  float m_fColor[3];
  TDPOINT m_start;
  VECTOR m_slope;
  TDPOINT m_curPos;
};

//typedef auto_ptr<CObject> AObject;

class CStarWarsController : public COpenGLWndController
{
public:
  CStarWarsController(float fStarSpeed,int iNumStars,bool bPointStars);
  virtual ~CStarWarsController();

  void Start();
  void Idle();

  virtual int  ValidatePixelFormat(HDC hdc,int suggestedFormat);
  virtual void WindowSized(int cx,int cy);
  
  virtual void Init();
  virtual void Close();
private:
  virtual void vDraw();
  bool GLExtensionExists(const char *extension);
  float GetRandom(float min,float max);
  void InitStars();

  float m_fStarSpeed;
  float m_fTimeElapsed;
  int m_iNumStars;
  bool m_bStarted;
  bool m_bPointStars;
  bool m_bMultiSample;
  GLYPHMETRICSFLOAT m_agmf[MAX_TEXT];
//  CObject *pObjects[NUMOBJECTS];
  vector<CObject *> pObjects;
  LPSTAR m_pStars;
  LARGE_INTEGER m_start;
  LARGE_INTEGER m_starStart;
  LARGE_INTEGER m_freq;
};

#endif