//	VirtualDub - Video processing and capture application
//	Modification for PNG support
//  Added by Cyrius, using libpng 1.2.4 and zlib 1.1.4
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_VIDEOSOURCEIMAGESPNG_H
#define f_VIDEOSOURCEIMAGESPNG_H

#include <windows.h>

#include "../VideoSourceImages.h"
#include "../VideoSource.h"
#include "../VBitmap.h"
#include "png.h"

void png_error_fn(png_structp png_ptr, png_const_charp error_msg);
void png_warning_fn(png_structp png_ptr, png_const_charp warning_msg);
void png_read_data_fn(png_structp png_ptr, png_bytep data, png_size_t length);

class VideoSourceImagesPNG : public VideoSourceImages {
private:
	png_structp png_ptr;
	png_infop info_ptr;
	png_infop end_info;
	void _reset(void);
	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;
protected:
public:
	VideoSourceImagesPNG(const char *pszBaseFormat);
	~VideoSourceImagesPNG();

	int _read(LONG lStart, LONG lCount, LPVOID lpBuffer, LONG cbBuffer, LONG *lBytesRead, LONG *lSamplesRead);
};

#endif
