//	VirtualDub - Video processing and capture application
//	Modification for PNG support
//  Added by Cyrius, using libpng 1.2.4 and zlib 1.1.4
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_AVIOUTPUT_IMAGES_PNG_H
#define f_AVIOUTPUT_IMAGES_PNG_H

#include <windows.h>
#include <vfw.h>

#include "png.h"

#include "../AVIOutputImages.h"

extern void png_error_fn(png_structp png_ptr, png_const_charp error_msg);
extern void png_warning_fn(png_structp png_ptr, png_const_charp warning_msg);
void png_write_data_fn(png_structp png_ptr, png_bytep data, png_size_t length);
void png_flush_data_fn(png_structp png_ptr);

class AVIVideoImagePNGOutputStream : public AVIVideoImageOutputStream {
private:
	png_structp png_ptr;
	png_infop info_ptr;
	void _reset(void);
public:
	AVIVideoImagePNGOutputStream(AVIOutput *out, const char *pszPrefix, const char *pszSuffix, int iDigits);
	virtual ~AVIVideoImagePNGOutputStream(void);
	BOOL write(LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer, LONG lSamples);
};

#endif
