//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_VIRTUALDUB_JOB_H
#define f_VIRTUALDUB_JOB_H

// 01/12/2002, Cyrius : Net mods
// JobWindowState
#define JWS_DETECT	0
#define JWS_MASTER	1
#define JWS_SLAVE	2
#define JWS_SINGLE	4
#define JWS_WAITING 8
#define JWS_RUNNING	16
#define JWS_NOT_RUNNING 32

// Network-to-Windowhandle-IDs
#define IDC_MASTER_SOCKET		21000
#define IDC_SLAVE_SOCKET		21001
#define IDC_START_NETWORKJOB	21002
#define IDC_STOP_NETWORKJOB		21003
#define IDC_SEND_STATUS			21004
#define IDC_SHUTDOWN_CLIENTS	21005
#define IDC_CLEAR_LOGFILE		21006

// Other Windowhandles
#define MYWM_TRAYICON			22001


// Network Message IDs
#define IDN_SHUTDOWN			0x1000		// Master  -->  Slave		, noparam
#define IDN_STARTNETJOB			0x1001		// Master  -->  Slave		, noparam
#define IDN_PARTCOMPLETE		0x1002		// Slave   -->  Master		, noparam
#define IDN_ABORTJOB			0x1003		// Master  -->  Slave		, noparam
#define IDN_PARTABORTED			0x1004		// Slave   -->  Master		, noparam
#define	IDN_REQUESTPART			0x1005		// Slave   -->  Master		, noparam
#define	IDN_NOMOREPARTS			0x1006		// Master  -->  Slave		, noparam
#define IDN_EXECSCRIPT			0x1007		// Master  -->  Slave		, (int)size, (int)From, (int)To, char[size]
#define IDN_PROGRESSINFO		0x1008		// Slave   <-->  Master		, (int)percent
#define IDN_STATUSINFO			0x1009		// Master  -->  Slave		, (NetworkTransferInfo)NTI
#define IDN_CLOSE				0x1010		// Master  -->  Slave		, noparam

// HostInfo
#define	HI_OFFLINE		1
#define	HI_LOCALHOST	2
#define HI_MASTER		3
#define HI_SLAVE		4
#define HI_DISCONNECT	5 
#define HI_ILLEGAL_MASTER 6

// FrameType
#define FT_DONE			1
#define	FT_TODO			2
#define	FT_DOING_DONE	3
#define FT_DOING_TODO	4

// PartInfo
#define PI_TODO		-1
#define PI_DONE		-2
#define PI_NONE		-4
#define PI_PROGRESS -8
#define	PI_SHEDULED -16

#define PI_VALID	(PI_TODO+PI_DONE+PI_PROGRESS+PI_SHEDULED)

//VDub	NanDub  <-- values used for
//23005	23001
#define SLAVE_LISTEN_PORT	23009
//23006	23002
#define MASTER_LISTEN_PORT	23010
//23007	23003
#define SLAVE_CONNECT_PORT	23011
//23008	23004
#define MASTER_CONNECT_PORT	23012


#define FD_MOSTFLAGS	(FD_READ|FD_WRITE|FD_ACCEPT|FD_CONNECT|FD_CLOSE)


#include <stdio.h>
#include "List.h"
#include "Error.h"
#include "InputFile.h"


class DubOptions;
class InputFilenameNode;
template<class T> class List2;

void OpenJobWindow();
void StartSlaveMode();
void CloseJobWindow();
bool InitJobSystem();
void DeinitJobSystem();
//==============================//
//=====  MODIFICATION OGM  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
//void JobAddConfiguration(const DubOptions *, const char *szFileInput, int iFileMode, const char *szFileOutput, bool fUseCompatibility, List2<InputFilenameNode> *pListAppended, long lSpillThreshold, long lSpillFrameThreshold);
void JobAddConfiguration(const DubOptions *, const char *szFileInput, int iFileMode, const char *szFileOutput, struct _avi_info *infos, bool fUseCompatibility, List2<InputFilenameNode> *pListAppended, long lSpillThreshold, long lSpillFrameThreshold, const char *outputType="AVI", int audioOnly=0);
//END ==========================//
void JobAddConfigurationImages(const DubOptions *opt, const char *szFileInput, int iFileMode, const char *szFileOutputPrefix, const char *szFileOutputSuffix, int minDigits, int imageFormat, List2<InputFilenameNode> *pListAppended);
void JobWriteConfiguration(FILE *f, DubOptions *);
void JobLockDubber();
void JobUnlockDubber();
void JobPositionCallback(LONG start, LONG cur, LONG end, int progress);
void JobClearList();
void JobRunList();
void JobAddBatchDirectory(const char *srcDir, const char *dstDir);
bool JobIsNetworkMode();

#endif
