//	VirtualDubMod - Video processing and capture application based on VirtualDub by Avery Lee
//	Copyright (C) 1998-2002 VirtualDubMod Developers
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "about_mod.h"
#include <windows.h>
#include <time.h>
#include <vfw.h>
#include "starwars.h"
#include "openglwnd.h"

extern HINSTANCE g_hInst;
//HWND l_hDlg;
//CStarWarsController *pController;

static void CALLBACK AboutModTimerProc(UINT uID, UINT, DWORD dwUser, DWORD, DWORD) {
	PostMessage((HWND)dwUser, WM_APP+0, 0, 0);
/*	MSG msg;
	CStarWarsController *pController = (CStarWarsController*) dwUser;

	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
	{
		if (msg.message != WM_APP) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	if (pController) {
		// do idle processing
		pController->Idle();
		// now redraw
		pController->Draw();
		InvalidateRect(l_hDlg, NULL, true);
	}*/
}

BOOL APIENTRY AboutModDlgProc( HWND hDlg, UINT message, UINT wParam, LONG lParam)
{
	static bool bTimerSet;
	static MMRESULT mmTimer;
	static CStarWarsController *pController;
	static HWND hGL;

    switch (message)
    {
        case WM_INITDIALOG:
			{
				RECT rt;
				PIXELFORMATDESCRIPTOR pfd;
				//HWND hGL;

//				l_hDlg = hDlg;

				bTimerSet = false;
				mmTimer = 0;

//				if (!pController)
				pController = new CStarWarsController(10.0f,0,true);
				if (!pController)
					EndDialog(hDlg, false);
				GetClientRect(hDlg, &rt);
				
				// setup how i want the window to be
				ZeroMemory(&pfd,sizeof(pfd));
				pfd.nSize = sizeof( pfd );
				pfd.nVersion = 1;
				pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
				pfd.iPixelType = PFD_TYPE_RGBA;
				pfd.cColorBits = 24;
				pfd.cAlphaBits = 8;
				pfd.cDepthBits = 16;
				pfd.iLayerType = PFD_MAIN_PLANE;

				// create the opengl window
				hGL = CreateOpenGLWindow(g_hInst,hDlg,WS_CHILDWINDOW | WS_VISIBLE,0,&rt,pController,&pfd);
				if (!hGL)
					EndDialog(hDlg, false);

				try
				{	
					ShowWindow(hGL, SW_SHOW);
					pController->Start();
				}
				catch (CError &err)
				{
					DestroyWindow(hGL);
					EndDialog(hDlg, false);
					// ok we're done now
				}

/*				if (TIMERR_NOERROR == timeBeginPeriod(5)) {
					bTimerSet = true;
					mmTimer = timeSetEvent(15, 5, AboutModTimerProc, (DWORD)hDlg, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
//					mmTimer = timeSetEvent(15, 15, AboutModTimerProc, (DWORD)pController, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
				}*/
			}
			return TRUE;

		case WM_SHOWWINDOW:
			{
				if (!bTimerSet)
				if (TIMERR_NOERROR == timeBeginPeriod(5)) {
					bTimerSet = true;
					mmTimer = timeSetEvent(5, 5, AboutModTimerProc, (DWORD)hDlg, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
//					mmTimer = timeSetEvent(15, 15, AboutModTimerProc, (DWORD)pController, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
				}
			}
			return TRUE;

		case WM_CLOSE:
			{
				if (mmTimer)
					timeKillEvent(mmTimer);

				if (bTimerSet)
					timeEndPeriod(5);

				if (hGL) DestroyWindow(hGL);
				pController = NULL;

				bTimerSet = false;

				EndDialog(hDlg, true);
			}
			return TRUE;

		case WM_APP:
			{	
				MSG msg;
				while (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
				{
					if (msg.message != WM_APP) {
						TranslateMessage(&msg);
						DispatchMessage(&msg);
					}
				}
				if (pController) {
					// do idle processing
					pController->Idle();
					// now redraw
					pController->Draw();
					//InvalidateRect(hDlg, NULL, false);
				}
			}
			return TRUE;

    }
    return FALSE;
}