require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Theme
			attr_reader :local_styles

			include BaseModule
			def ondesc; <<DSC; end
The system plugin can edit the theme.
{{{
#theme [cols] [rows] [theme-name] [element-name]
#theme img [theme-name]
#theme short
#theme local style [theme-name]
}}}
||cols ||Specify the number of columns of textarea.
||rows ||Specify the number of rows of textarea.
||short||The parameter shows the list of the themes.
||local||Define the local style on the page.
DSC
			ERR = Hash::new unless defined? ERR
			ERR['INV_CMT'] = "Comment /* */ can not be specified."
			ERR['INV_ELM'] = "Invalid element name is specified."
			ERR['INV_ESC'] = "Escape character (\\) can not be specified."
			ERR['INV_FIL'] = "Invalid file name."
			ERR['INV_URI'] = "URI can not be specified."
			ERR['INV_WRD'] = "Invalid words specified."
			ERR['MOD_CHK'] = 'The theme already modified.'
			ERR['NOP_THM'] = "You can not edit ThemePark."
			ERR['NON_THM'] = "Theme not found. %1"
			HED = Hash::new unless defined? HED
			HED['ALL_IMG'] = 'All image files'
			HED['ALL_THM'] = "All Themes"
			HED['ALT_THM'] = 'Regist and alter theme element'
			HED['REG_IMG'] = 'Regist image files'
			HED['THM_ELM'] = "Element of Theme %1"
			HED['THM_SAM'] = 'Sample for element'
			LBL = Hash::new unless defined? LBL
			LBL['ALT_THM'] = 'AlterTheme'
			LBL['ATH_NAM'] = 'Creator'
			LBL['CMT_NAM'] = 'Comment'
			LBL['DEL_ELM'] = 'DeleteElement'
			LBL['DEL_IMG'] = 'DeleteImage'
			LBL['ELM_NAM'] = 'ElementName'
			LBL['FRT_POS'] = "before %1"
			LBL['INS_POS'] = 'InsertPosition'
			LBL['POS_LAS'] = 'last'
			LBL['REG_ELM'] = 'RegistElement'
			LBL['REG_IMG'] = 'RegistImage'
			LBL['THM_NAM'] = 'ThemeName'
			LBL['THM_SAM'] = 'Sample'
			LBL['THM_STY'] = 'Style'
			LBL['ZIP_DWN'] = 'Download'

			def safe; 3 ; end
			def onpost
				raise ERR['NOP_THM'] unless @sys['EDITTHEME']
				name = @sys.cgi.params['theme_newname'][0]
				name = @sys.cgi.params['theme_name'][0] if name.nil? or name.empty?
				theme = @sys.themes[name]
				theme = @sys.theme unless theme
				@sys.theme = theme if @sys.cgi.params['theme_change'][0] == 'true'
				case @sys.cgi.params['theme_target'][0]
				when 'image' then
					case @sys.cgi.params['theme_mode'][0]
					when 'add' then
						theme.img.put(@sys.cgi.params['theme_file'][0])
					when 'del' then
						theme.img[@sys.cgi.params['theme_file'][0]].delete
					end
				when 'element' then
					case @sys.cgi.params['exec'][0]
					when LBL['REG_ELM'] then
						order = @sys.cgi.params['theme_order'][0]
						order = nil if order.empty?
						csselm = ThemeElm::new
						csselm.name = @sys.cgi.params['theme_elm'][0]
						csselm.author = @sys.cgi.params['theme_author'][0]
						csselm.comment = @sys.cgi.params['theme_comment'][0]
						csselm.sample = @sys.cgi.params['theme_sample'][0]
						csselm.css = @sys.cgi.params['theme_css'][0]
						csselm.time = @sys.cgi.params['theme_time'][0]
						raise ERR['INV_ELM'] unless /^[A-Za-z0-9_\.\#, ]+$/ === csselm.name
						checkcss(csselm.css)
						theme.load
						theme.update(csselm, order)
						theme.write
						raise VikiWiki::Location, uri4get({'theme_elm'=>csselm.name})
					when LBL['DEL_ELM'] then
						theme.delete(@sys.cgi.params['theme_elm'][0])
						raise VikiWiki::Location
					end
				end
			end
			def onview
				case @prms[0]
				when 'short' then
					return shortview
				when 'local' then
					return localtheme
				when 'img' then
					raise ERR['NOP_THM'] unless @sys['EDITTHEME']
					return img_form(@sys.themes[@prms[1]])
				else
					raise ERR['NOP_THM'] unless @sys['EDITTHEME']
					return theme_form
				end
			end
		private
			def theme_list
				CGI::element('ul'){|li|
					@sys.themes.each{|theme|
						uri = uri4get({'h'=>theme.name, 'f'=>nil})
						li << CGI::element('li'){
							CGI::element('a', {'href'=>uri}, theme.name)
						}
					}
				}
			end
			def theme_form
				res = Array::new
				theme = @sys.theme
				elm = theme[@sys.cgi.params['theme_elm'][0]]
				cols, rows, ptheme, pelm, = @prms
				cols = cols.to_i
				rows = rows.to_i
				cols = 40 if cols < 1
				rows = 10 if rows < 1
				ptheme = nil if ptheme and ptheme.empty?
				pelm = nil if pelm and pelm.empty?
				if ptheme then
					theme = @sys.themes[ptheme]
					raise ERR['NON_THM'].emb(ptheme) unless theme.exist?
					elm = nil
					if pelm then
						elm = theme[pelm] || ThemeElm::new(pelm)
						return uni_form(theme, elm, cols, rows)
					end
				end

				unless ptheme then
					res << CGI::element('h2', nil, HED['ALL_THM'])
					res << theme_list
				end
				if theme then
					res << CGI::element('h2', nil, HED['THM_ELM'].emb(theme.name))
					res << elm_table(theme)
					if elm then
						res << CGI::element('h2', nil, HED['THM_SAM'])
						res << sample(theme, elm)
						res << CGI::element('h2', nil, HED['ALT_THM'])
					end
					res << elm_form(theme, elm, cols, rows)
					res << CGI::element('h2', nil, HED['REG_IMG'])
					res << img_form(theme)
				end
				return res.join("\n")
			end
			def sample(theme, elm)
				CGI::element('div'){
					Parser::trans_html(@sys, elm.sample)
				}
			end
			def elm_form(theme, elm, cols, rows)
				elm = VikiWiki::ThemeElm::new unless elm
				lbl_themes = ['']
				@sys.themes.each{|t|
					lbl_themes << t.name
				}
				lbl_elms = Array::new
				theme.elms.each{|e|
					next unless e.name
					lbl_elms << [e.name, LBL['FRT_POS'].emb(e.name)]
				}
				lbl_elms << ['', LBL['POS_LAS']]
				attr = {
					'theme_change' => 'true',
					'theme_target' => 'element',
					'theme_time'   => elm.time,
				}
				plugin_form(attr) {|recv|
					recv << [LBL['THM_NAM'],
							select('theme_name', theme.name, lbl_themes)+
							text('theme_newname', '', 10)]
					recv << [LBL['ELM_NAM'], text('theme_elm', elm.name, cols)]
					recv << [LBL['ATH_NAM'], text('theme_author', elm.author, cols)]
					recv << [LBL['CMT_NAM'], text('theme_comment', elm.comment, cols)]
					recv << [LBL['INS_POS'], select('theme_order', elm.name.to_s, lbl_elms)]
					recv << [LBL['THM_STY'], textarea('theme_css', elm.css, cols, rows)]
					recv << [LBL['THM_SAM'], textarea('theme_sample', elm.sample, cols, rows)]
					recv << [submit('exec', LBL['REG_ELM'])+' '+submit('exec', LBL['DEL_ELM']), nil]
				}
			end
			def uni_form(theme, elm, cols, rows)
				attr = {
					'theme_change'  => 'false',
					'theme_target'  => 'element',
					'theme_name'    => theme.name,
					'theme_elm'     => elm.name,
					'theme_author'  => elm.author,
					'theme_comment' => elm.comment,
					'theme_order'   => elm.name,
					'theme_sample'  => elm.sample,
					'theme_time'    => elm.time,
				}
				plugin_form(attr) {|recv|
					recv << [
						LBL['THM_STY'],
						textarea('theme_css', elm.css, cols, rows)
					]
					recv << [
						submit('exec', LBL['REG_ELM']) + ' ' +
						submit('exec', LBL['DEL_ELM']), nil
					]
				}
			end
			def elm_table(theme)
				res = Array::new
				res << [
					LBL['ELM_NAM'],
					LBL['ATH_NAM'],
					LBL['CMT_NAM']
				]
				theme.elms.each{|elm|
					next unless elm.name
					uri = uri4get({'h'=>theme.name, 'f'=>nil, 'theme_elm'=>elm.name})
					ahref = CGI::element('a', {'href'=>uri}, elm.name)
					res << [
						ahref,
						elm.author,
						elm.comment
					]
				}
				to_table(res, nil, 'top')
			end
			def shortview
				themes = @sys.themes.map do |theme|
					theme.name
				end
				plugin_form({'h'=>nil}) do
					select('h', @sys.theme.name, themes) +
					"\n" +
					submit('exec', LBL['ALT_THM'])
				end
			end
			def localtheme
				_, css, target, = @prms
				return '' if target and @sys.theme.name != target
				checkcss(css)
				local = @sys.html_headers.select{|m| /<\/style>/ === m}
				if local.empty? then
					@sys.html_headers << <<EOS
<style type="text/css">
#{css}
</style>
EOS
				else
					local.last.sub!(/<\/style>/, "#{css}\n</style>")
				end
				return ''
			end
			def img_form(theme)
				theme = @sys.theme unless theme
				return '' unless theme
				res = Array::new
				res << multipart_plugin_form({'theme_mode'=>'add', 'theme_target'=>'image'}, {}, false) {|recv|
					recv << file('theme_file', '')
					recv << submit('exec', LBL['REG_IMG'])
				}
				res << plugin_form({'theme_mode'=>'del', 'theme_target'=>'image'}) {|recv|
					theme.img.each_file{|img|
						recv << [
							radio('theme_file', img.name),
							img.link,
							File::mtime(img.path).tms
						]
					}
					recv << [submit('exec', LBL['DEL_IMG']), nil, nil]
				}
				return res
			end
			INVWORDS = /javascript|vbscript|cookie|eval|expression|behavior|behaviour|binding|include\-source/
			def checkcss(css)
				return if @sys['SAFE'] < 2
				raise Message::new(:FUNC_THEME_URI_INVALID_PROTCOL) if /(http|https|ftp|mailto|file):\/\// === css
				raise Message::new(:FUNC_THEME_ESCAPE_DENIED) if /\\/ === css
				raise Message::new(:FUNC_THEME_COMMENT_DENIED) if /\/\*|\*\// === css
				raise Message::new(:FUNC_THEME_INVALID_KEYWORD) if INVWORDS === css
			end
		end
	end
end
