require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Links
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can show the links to refer the page.
The part described to be "page" to "format" replaces the page name.
If you specify "/except-pattern/", the matched links is not displayed.
{{{
#links [/except-pattern/] [format] [page]
}}}
DSC

			def safe; 5 ; end
			def onview
				prms = @prms.dup
				prm = prms.shift
				if /^\/(.+)\/$/ === prm then
					except = Regexp::new($1)
					prm = prms.shift
				end
				format = prm
				prm_pages = prms
				format = "[[page]]" if format.to_s.empty?
				pages = prm_pages.empty? ? [@sys.page.name] : prm_pages
				links = Array::new
				pages.each{|page|
					next unless @sys.links[page]
					@sys.links[page].each{|link|
						next if except and except === link
						links << link
					}
				}
				res = Array::new
				links.uniq.sort.each{|link|
					page = @sys.pages[link]
					next unless page.exist?
					next if @sys.static? and not page.static.exist?
					next if prm_pages.empty? and @sys.page.name == page.name
					reps = {'page'=>page.name, 'alias'=>page.alias}
					res << format.replace_words(reps)
				}
				return Parser::trans_html(@sys, res.join("\n"), 'VikiWikiStyle')
			end
		end
	end
end
