class XPath
	def initialize(path)
		@path = path.split('/').map{|name|
			if /\[@(\w+)=(["']?)(.*?)\2\]$/ === name then
				[$`, {$1=>$3}]
			else
				[name, {}]
			end
		}
	end
	def eval(node)
		@path.each do |name, attr|
			return node.getTextValues.join("\n") if name == 'text()'
			return nil unless node.hasChildNodes
			list = node.childNodes
			0.upto(list.length-1) do |i|
				node = list.item(i)
				if node.nodeName == name then
					attr.each do |key, val|
						return nil if val != node.getAttribute(key)
					end
					break
				end
				node = nil
			end
			return nil unless node
		end
		return node
	end
end
