module Log
	@@dir = '.'
	@@flog = nil
	@@plog = nil
	def Log::dir=(path)
		@@dir = path
	end
	def Log::debug(name, *vals)
		unless @@flog then
			@@flog = File::open("#{@@dir}/debug.log", "w")
			@@flog.puts("*** PID:%d, TIME:%s ***" % [$$, Time::now.strftime("%Y-%m-%d %H:%M:%S")])
		end
		now = Time::now
		@@flog.puts("--- %s %s %s.%06d ---" % [caller.first, name, now.strftime("%Y-%m-%d %H:%M:%S"), now.usec])
		@@flog.puts(*vals)
		@@flog.flush
	end
	def Log::perform
		@@plog = File::open("#{@@dir}/perform.log", "w") unless @@plog
		now = Time::now
		@@plog.printf("%s.%06d\t%s\n", now.strftime("%Y-%m-%d %H:%M:%S"), now.usec, caller.first)
	end
	def Log::rescue(*vals)
		lines = Array::new
		if File::exist?("#{@@dir}/rescue.log") then
			lines = File::readlines("#{@@dir}/rescue.log")
			lines = lines[-1, 1000] if lines.size > 1000
		end
		File::open("#{@@dir}/rescue.log", "w") do |flog|
			flog.write(lines.join)
			flog.puts("*** PID:%d, TIME:%s ***" % [$$, Time::now.strftime("%Y-%m-%d %H:%M:%S")])
			now = Time::now
			flog.puts("--- %s, %s %s.%06d ---" % [caller.first, name, now.strftime("%Y-%m-%d %H:%M:%S"), now.usec])
			flog.puts(*vals)
		end
	end
	def Log::access(filter, *vals)
		file = "#{@@dir}/access.log"
		str = vals.join("\t")
		case filter
		when String then
			return unless str.include?(filter)
		when Regexp then
			return unless filter === str
		end
		LockFile::lock(file) do
			File::open(file, "a") do |slog|
				now = Time::now
				slog.print now.strftime("%Y-%m-%d %H:%M:%S")
				slog.printf(".%06d\t%d\t", now.usec, $$)
				slog.puts str
			end
		end
	end
end
