require 'istore'

module VikiWiki
	class Datas
		include Enumerable
		attr_reader :file
		def initialize(file, dflt={})
			@file = file
			@dflt = dflt
		end
		def datas
			@db = IStore::new(@file, @dflt) unless @db
			@datas = @db.read unless @datas
			@datas = @dflt.dup unless @datas
			return @datas
		end
		def replace(datas)
			@datas = datas
		end
		def [](name)
			return self.datas[name]
		end
		def []=(name, val)
			self.datas
			@datas[name] = val
		end
		def delete(name)
			self.datas
			@datas.delete(name) if self.datas.key?(name)
		end
		def update(sync_time=nil)
			datas = self.datas
			@db.write(datas, sync_time)
		end
		def each
			datas = self.datas
			case @dflt
			when Array then
				datas.each{|data|
					yield data
				}
			when Hash then
				datas.sort.each{|name, data|
					yield name, data
				}
			end
		end
		def mtime
			File::exist?(@file) ? File::mtime(@file) : nil
		end
		def empty?
			self.datas.to_a.empty?
		end
	end
	class Admins < Datas
		def initialize(file, *admins)
			@admins = admins
			super(file, [])
		end
		def include?(name)
			return true if @admins.include?(name)
			return true if self.datas.include?(name)
			return false
		end
		def <<(name)
			self.datas << name unless self.datas.include?(name)
		end
		def delete(name)
			self.datas.delete(name) if self.datas.include?(name)
		end
	end
	class Aliases < Datas
		def initialize(file, lang)
			@lang = lang
			super(file)
		end
		def [](name)
			return nil if @lang == 'en'
			super
		end
		def []=(name, val)
			self.datas
			old = @datas.index(val)
			raise Message::new(:PAGE_ALIAS_ALREADY_EXISTS, old, val) if old and old != name
			@datas[name] = val
		end
		def regexp(name)
			self.datas.each{|nam, als|
				next unless /^\/(.+)\/$/ === nam
				re = Regexp::new($1)
				return re, als if re === name
			}
			return nil
		end
		def get(name)
			als = self[name]
			unless als then
				re, als = regexp(name)
				als = re ? name.sub(re, als) : name
			end
			return als
		end
	end
	class Links < Datas
		def update(page=nil, all_pages=nil)
			if self.datas[page] and all_pages then
				self.datas[page].delete_if{|name|
					not all_pages.include?(name)
				}
			end
			genlinks(self.datas, page, all_pages) if page
			super()
		end
		def generate(all_pages)
			File::unlink(@file) if File::exist?(@file)
			all_names = all_pages.map{|p| p.name}
			errs = Array::new
			all_pages.each{|page|
				begin
					genlinks(self.datas, page, all_names)
				rescue StandardError, ScriptError
					errs << "\"#{page.name} - #{$!}\""
				end
			}
			errs = errs.join(',')
			update
			raise Message::new(:FUNC_LINK_GEN_ERROR, errs) unless errs.empty?
		end
		def genlinks(datas, page, all_pages)
			datas.each_value{|v|
				v.delete_if{|name| name == page.name}
			}
			page.links.uniq.each{|link|
				datas[link] = Array::new unless datas.key?(link)
				datas[link] << page.abs_name unless datas[link].include?(page.abs_name)
			}
			return datas
		end
		def forward

		end
	end
	class Farm
		attr_reader :address, :author, :purpose, :name, :toppage
		def initialize(address, author, purpose, name, toppage, site)
			@address, @author, @purpose, @name, @toppage, @site =
			 address,  author,  purpose,  name,  toppage, site
		end
		def to_hash
			data = Hash::new
			data['address'] = @address
			data['author'] = @author
			data['purpose'] = @purpose
			data['name'] = @name
			data['site'] = @site
			data['toppage'] = @toppage
			return data
		end
	end
	class Farms < Datas
		def initialize(file, farmdir)
			@farmdir = farmdir
			super(file)
		end
		def datas
			return @datas if @datas
			super
			hash = Hash::new
			@datas.each{|key, data|
				hash[key] = Farm::new(
					data['address'],
					data['author'],
					data['purpose'],
					data['name'],
					data['site'],
					data['toppage']
				)
			}
			@datas = hash
		end
		def update
			datas = Hash::new
			self.datas.each{|key, data|
				datas[key] = data.to_hash
			}
			@db.write(datas)
		end
		def each_path
			self.datas.keys.each do |name|
				yield path(name)
			end
		end
		def path(name)
			[@farmdir, name].path
		end
	end
	class InterWikis < Datas
		attr_reader :system
		def initialize(file, system)
			@system = system
			super(file)
		end
		def each_system
			@system.each{|k, v|
				yield k, v
			}
		end
		def each_all
			self.datas.each{|k, v|
				yield k, v
			}
			@system.each{|k, v|
				next if @datas.key?(k)
				yield k, v
			}
		end
	end
	class Counter < Datas
		def update(page)
			self.datas[page] = self.datas[page].to_i + 1
			super()
		end
	end
	class Indexes < Datas
		def update(ini, word, pages)
			index = self.datas
			if pages then
				index[ini] = Hash::new unless index.key?(ini)
				iini = index[ini]
				iini[word] = pages
			elsif index.key?(ini) then
				index[ini].delete(word) if word
				index.delete(ini) if word.nil? or index[ini].size == 0
			end
			@db.write(index)
		end
	end
	class AccessControl
		attr_accessor :type, :users, :target, :r, :w, :x
		def initialize(id=nil, type=nil, users=nil, target=nil, r=nil, w=nil, x=nil)
			@id, @type, @users, @target, @r, @w, @x = \
			 id,  type,  users,  target,  r,  w,  x
		end
		def id
			@id = [@type, @users, @target].map{|x| x.inspect}.join(',')
		end
		alias reid id
		def readable?; @r; end
		def writable?; @w; end
		def executable?; @x; end
		def to_a
			[@id, @type, @users, @target, @r, @w, @x]
		end
		def ==(other)
			if self.class == other.class then
				self.id == other.id
			else
				self.id == other
			end
		end
	end
	class AccessControls < Datas
		attr_reader :system
		def initialize(file, system)
			@system = system
			super(file, [])
		end
		def datas
			super
			@datas.map!{|data|
				AccessControl::new(*data)
			}
		end
		def <<(ac)
			@datas << ac
		end
		def delete(id)
			@datas.delete_if{|data| data.id == id}
		end
		def update
			datas = self.datas.map{|data|
				data.to_a
			}
			@db.write(datas)
		end
		def each_system
			self.system.each{|v|
				yield v
			}
		end
		def each_all
			(self.system + self.datas).each{|v|
				yield v
			}
		end
		def swap(fid, tid)
			return if fid == tid
			from = self.datas[self.datas.index(fid)]
			to = @datas[@datas.index(tid)]
			return if from.nil? or to.nil?
			@datas.map!{|data|
				case data.id
				when fid then to
				when tid then from
				else data
				end
			}
		end
	end
end
