module VikiWiki
	SYSDIRNAMES = [
		DATANAM   = 'data',
		ETCNAM    = 'etc',
		FARMNAM   = 'farm',
		IMGNAM    = 'img',
		MSGDIR    = 'msg',
		RHTMLNAM  = 'rhtml',
		SCRIPTDIR = 'script',
		TEXTNAM   = 'text',
		THEMENAM  = 'theme'
	]
	IMG_EXT       = "\.(?i:jpg|jpeg|png|gif)"
	RE_IMG_EXT    = /#{IMG_EXT}$/
	RE_IDENT      = /^[A-Za-z_\.][A-Za-z0-9_\.-]*$/
	MASTERDIR     = File::dirname(File::dirname(__FILE__)) + '/master'
	PAGES = [
		AdminPage      = 'AdminPage',
		AliasName      = 'AliasName',
		AnErrorOccurred= 'AnErrorOccurred',
		BaseUri        = 'BaseUri',
		BottomBar      = 'BottomBar',
		CgiPage        = 'CgiPage',
		CgiEdit        = 'CgiEdit',
		CountPage      = 'CountPage',
		EditPage       = 'EditPage',
		EucPage        = 'EucPage',
		HelpPage       = 'HelpPage',
		HistoryPage    = 'HistoryPage',
		ImagesPage     = 'ImagesPage',
		IndexPage      = 'IndexPage',
		InterWikiName  = 'InterWikiName',
		LangPage       = 'LangPage',
		LayoutPage     = 'LayoutPage',
		LinkBar        = 'LinkBar',
		LinksPage      = 'LinksPage',
		ListPage       = 'ListPage',
		MenuBar        = 'MenuBar',
		NewPage        = 'NewPage',
		PluginsPage    = 'PluginsPage',
		ReservedPages  = 'ReservedPages',
		SearchPage     = 'SearchPage',
		SecurityPage   = 'SecurityPage',
		SelfPage       = 'SelfPage',
		SideBar        = 'SideBar',
		SjisPage       = 'SjisPage',
		SourcePage     = 'SourcePage',
		StaticLayout   = 'StaticLayout',
		StaticPage     = 'StaticPage',
		TemplatePage   = 'TemplatePage',
		ThemePark      = 'ThemePark',
		TopPage        = 'TopPage',
		UpdateStatic   = 'UpdateStatic',
		UtfPage        = 'UtfPage',
		VikiWikiStyleHelpPage = 'VikiWikiStyleHelpPage',
		WikiFarm       = 'WikiFarm',
		XML            = 'XML',
		HTML           = 'HTML',
	]
	ALLSTYLES = ['VikiWikiStyle','AsWikiStyle','FreeStyleWikiStyle','HikiStyle','PukiWikiStyle','TikiStyle','YukiWikiStyle']
	# local setting
	CONF = {
		'ADDRESS'       => nil,
		'ADMIN'         => 'vikiwiki',
		'ATTACHDIR'     => nil,
		'ATTACHESCAPE'  => true,
		'ATTACHURI'     => nil,
		'AUTHOR'        => 'HOGE hogehoge',
		'AUTHTYPE'      => 'form',
		'AUTOLINK'      => false,
		'ALTREFER'      => false,
		'BACKUP'        => true,
		'BASEDIR'       => nil,
		'BASEURI'       => nil,
		'CVSROOT'       => nil,
		'DEFAULTPRMS'   => nil,
		'DIFFCMD'       => nil,
		'EDITFILEFROM'  => nil,
		'EDITFILETO'    => nil,
		'EDITSYSTEM'    => false,
		'EDITTHEME'     => false,
		'ENCODING'      => 'utf-8',
		'FILEEXT'       => 'txt',
		'FILEMODE'      => '440',
		'FOOTER'        => nil,
		'HTMLTAG'       => false,
		'LANG'          => 'ja',
		'LANGS'         => ['ja','en'],
		'LANGSWITCH'    => false,
		'LAYOUT'        => nil,
		'LOG'           => false,
		'LOGDIR'        => $VIKIWIKITMP,
		'MODIFYCHECK'   => true,
		'NGWORDS'       => [],
		'OSCODE'        => \
			/Windows/i === ENV['OS'] ||\
			/PCK|SJIS/i === ENV['LANG'] ?\
			's' : 'e',
		'PAGENODE'      => true,
		'PLUGINENCLOSE' => false,
		'PLUGIN_HOOK_NAMES'  => nil,
		'PLUGIN_HOOK_SCRIPT' => nil,
		'RSSDESC'       => nil,
		'RSSFILE'       => 'rss.xml',
		'RSSNUM'        => 20,
		'SAFE'          => 0,
		'SCRIPT_NAME'   => nil,
		'SHORTWIKI'     => nil,
		'SHAREWIKIDIR'  => nil,
		'SHAREWIKIURI'  => nil,
		"SIBLINGWIKI"   => nil,
		'SITENAME'      => "VikiWiki",
		'STATICDIR'     => nil,
		'STATICEXCEPT'  => nil,
		'STATICIMG'     => nil,
		'STATICTHEME'   => nil,
		'STATICTITLE'   => nil,
		'STATICURI'     => nil,
		'STATICWIKI'    => nil,
		'THEMEBASE'     => ['sidebar-left'],
		'THEMECSS'      => 'vikiway',
		'TIMEOUT'       => 600,
		'TITLE'         => 'VikiWiki - page',
		'TOPPAGE'       => 'FrontPage',
		'WIKIFARM'      => false,
		'WIKIFARMFLAT'  => false,
		'WIKIPARENT'    => nil,
		'WIKISTYLES'    => ALLSTYLES,
	}
end
