require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class More
			include BaseModule
			LBL = Hash::new unless defined? LBL
			LBL['RED_MOR'] = 'more ...'
			def ondesc; <<DSC; end
The system plugin can display a part of pages.
{{{
#more page
#more sort=date,num=3,rows=10 pages ...
:pages:page name or regexp
}}}
DSC
			def safe; 5 ; end
			def onview
				opt = {'sort'=>'date','num'=>3,'rows'=>5}
				opt.update(getopt(@prms.shift)) if /\w+=\w+/ === @prms[0]
				hits = @sys.pages.glob(@prms)
				if opt['sort'] == 'date' then
					pages = Array::new
					times = Array::new
					hits.each do |name|
						next if PAGES.include?(name)
						page = @sys.pages[name]
						ltime = File::mtime(page.path)
						if pages.size <= opt['num'] or ltime < pages[0] then
							pages << [ltime, page]
							if pages.size > opt['num'] then
								pages = pages.sort.reverse
								pages.pop
							end
						end
					end
					pages.map!{|x| x[1]}
				else
					pages = hits
				end
				res = ''
				pages.each do |page|
					text = page.text.to_a[0,opt['rows']].join
					res << Parser::trans_html(@sys, "!#{page.name}", 'VikiWikiStyle')
					res << Parser::trans_html(@sys, text, page.style)
					res << Parser::trans_html(@sys, <<EOS, 'VikiWikiStyle')
<<<plugin-more-read
[[#{page.name} #{LBL['RED_MOR']}]]
>>>
EOS
				end
				return res
			end
			def getopt(str)
				opt = Hash::new
				str.split(',').each do |prm|
					key, val = prm.split('=')
					opt[key] = val
				end
				return opt
			end
		end
	end
end
