require 'vikiwikiplugin'
require 'plugin/edit'

module VikiWiki
	module Plugins
		class Altname < Edit
			def ondesc; <<DSC; end
The system plugin can alter a page name.
DSC
			def safe; 3 ; end
			def onpost
				super
			end
			def onview
				return '' unless @sys.page.exist?
				plugin_form {|recv|
					recv << [LBL['PAG_NAM'], text('edit_p', @sys.page.name)]
					recv << [LBL['ALS_NAM'], text('edit_alias', @sys.aliases[@sys.page.name])]
					recv << [submit('exec', LBL['ALT_NAM']), nil]
				}
			end
		end
	end
end
