#!/usr/bin/ruby

# 1) Specify the above path of ruby.
# 2) Specify the path of the VikiWiki CGI script.

SCRIPT_NAME = "/home/hogehoge/public_html/wiki/vikiwiki.cgi"

load SCRIPT_NAME

begin
	@sys = VikiWiki::Sys::new(__FILE__, @conf)
	@sys.setup
	raise "The request except POST is denied." if @sys.cgi.request_method.upcase != "POST"
	raise "The specified plugin #{@sys.cgi.params['pi_name'][0]} can not be used." unless Array === @sys['PLUGIN_HOOK_NAMES'] and @sys['PLUGIN_HOOK_NAMES'].include?(@sys.cgi.params['pi_name'][0])
	raise "The setting is not for the Static HTMLs." unless @sys.page.static
	@sys.plugin_onpost
	uri = @sys.page.static.uri
	@sys.print @sys.location(uri)
rescue Exception
		print <<EOS
Content-Type: text/html

<html>
<head>
<title>Update Error for VikiWiki</title>
</head>
<body>
<h1>Update Error</h1>
<p>#{CGI::escapeHTML($!.to_s)}</p>
<!--
#{CGI::escapeHTML($@.to_a.join("\n"))}
-->
<p>Back to the previous page and try again.</p>
<p>Or, call your system administrator.</p>
</body>
</html>
EOS
end
