$: << File::dirname(__FILE__.gsub(/\\/, '/'))+'/../vikiwiki/lib'
require 'diffcvs'
require 'cvswrapper'

basedir, workdir, cvsroot, project, _ = *ARGV

if basedir.nil? or cvsroot.nil? then
	puts <<EOS
Usage: ruby -Ku chgcvs.rb basedir workdir cvsroot project
basedir - text directory of VikiWiki site
workdir - work directory to change text directory
cvsroot - CVSROOT drectory (cvs's -d option)
project - project path under CVSROOT

basedir, workdir and cvsroot are the same level.

ex)
# ruby -Ku chgcvs.rb /home/hoge/www /home/hoge/tmp /home/hoge/cvs wiki/text

/home/hoge
  +- cvsroot
     +- CVSROOT
     +- wiki
        +- text
  +- tmp
     +- wiki
        +- text
  +- www
     +- wiki
        +- data
           :
        +- text

EOS
exit
end

basedir.gsub!(/\\/, '/')
workdir.gsub!(/\\/, '/')
cvsroot.gsub!(/\\/, '/')
project.gsub!(/\\/, '/')

#raise "work directory already exist." if File::exist?(workdir)
Dir::chdir(workdir)
File::mkpath(project)
prjroot = project.split('/').first

system("cvs -d #{cvsroot} init")
Dir::chdir(prjroot)
system("cvs -d #{cvsroot} import -m \"\" #{prjroot} VikiWiki init")
Dir::chdir("..")
system("cvs -d #{cvsroot} checkout #{project}")

Dir::chdir(project)

diff = DiffCVS::new
wrap = CVSwrapper::new(cvsroot, workdir)

basereg = /^#{Regexp::escape(basedir)}\//
newdir = "#{workdir}/"

Dir::glob("#{basedir}/#{project}/**/*") do |file|
	next if /\/\./ === file
	next if File::directory?(file)
	newfile = file.sub(basereg, newdir)
	printf("File: %s => %s\n", file, newfile)
	his = diff.getHistory(file)
	if his.empty? then
		lines = File::readlines(file)
		mtime = File::mtime(file)
		puts "\t=> no version\n"
		wrap.writeFile(newfile, lines, nil, nil, mtime)
	else
		his.each do |ver, user, time|
			puts "\t=> version: #{ver}\n"
			lines = diff.readFile(file, ver)
			wrap.writeFile(newfile, lines, nil, user, time)
		end
	end
end
