require 'wiki/vikiwikistyle'

module Wiki
	class JapaneseStyle < VikiWikiStyle

=begin
		このスタイルはMyWikiStyleの一例です。
		ベースはVikiWikiのスタイルで単純に記述文字に
		日本語を使用しただけの方法です。
		実際に作ってみての感想ですが、日本語スタイルは
		間に漢字変換が入り、それぞれの人で変換アプリの
		挙動が異なるので難しいと思いました。
=end

		# <pre>
		FM_PRE_S         = '＜以下整形済み＞'
		FM_PRE_E         = '＜以上整形済み＞'
		RE_PRE_S         = /^＜以下整形済み?＞$/
		RE_PRE_E         = /^＜以上整形済み?＞$/

		# <h1> to <h6>
		FM_H1            = '■%s'
		FM_H2            = '□%s'
		FM_H3            = '◆%s'
		FM_H4            = '◇%s'
		FM_H5            = '●%s'
		FM_H6            = '○%s'
		RE_H1            = /^■(.+)$/
		RE_H2            = /^□(.+)$/
		RE_H3            = /^◆(.+)$/
		RE_H4            = /^◇(.+)$/
		RE_H5            = /^●(.+)$/
		RE_H6            = /^○(.+)$/

		# <hr />
		FM_HR            = '＝＝＝＝'
		RE_HR            = /^－{4,}|＝{4,}|─{4,}|━{4,}$/

		# <div class="">
		FM_DIV_S         = '→%s'
		FM_DIV_E         = '←'
		RE_DIV_S         = /^→\s*([A-Za-z]\w*)?$/
		RE_DIV_E         = /^←$/

		# <ul>
		FM_UL            = '・%s'
		RE_UL            = /^・(.+)$/

		# <ol>
		FM_OL            = '１．%s'
		RE_OL            = /^(?:[０-９]+[．）])\s*(.+)$/

		# <dl>
		FM_DL            = '【%s】%s'
		RE_DL            = /^【([^】]+)】(.*)$/
		FM_DL2           = nil
		RE_DL2           = nil

		# <blockquote>
		FM_BLOCKQUOTE    = '＞%s'
		RE_BLOCKQUOTE    = /^＞(.+)$/

		# <table border="1">
		TX_TABLE         = ''
		RE_TABLE         = /^┃(.+)$/

		# <table>
		TX_TABLE_N       = ''
		RE_TABLE_N       = /^│(.+)$/

		# <!-- -->
		FM_COMMENT       = '＃%s'
		RE_COMMENT       = /^＃(.+)$/

		# plugin
		FM_PLUGIN        = '★%s%s%s'
		RE_PLUGIN        = /^★\s*(#{TX_IDENT})(?:\#(\S+))?(?:\s+(.+))?$/

		# WikiName
		FM_WIKINAME      = nil
		RE_WIKINAME      = nil

		# BracketName
		FM_BRACKETNAME   = '『%s』'
		RE_BRACKETNAME   = /^『(#{TX_WRIX})』/

		# AliasName
		FM_ALIASNAME     = '『%s %s』'
		RE_ALIASNAME     = /^『(#{TX_WRIX})\s+([^』]+)』/

		# <em>
		FM_EM            = nil
		RE_EM            = nil

		# <strong>
		FM_STRONG        = "＊%s＊"
		RE_STRONG        = /^＊([^＊]+)＊/

		# <del>
		FM_DEL           = '×%s×'
		RE_DEL           = /^×([^×]+)×/

		# escape
		FM_ESCAPE        = '；%s；'
		RE_ESCAPE        = /^；([^；]+)；/

		# link and image
		FM_A             = '「%s %s」'
		RE_A             = /^「(#{TX_INURL})\s+([^」]+)」/
		RE_URL           = /^(#{TX_URL})/
		RE_IMGEXT        = /#{TX_IMGEXT}$/
		RE_EMBIMG        = /^(\S+#{TX_IMGEXT})\s+(\S+)$/

		# plugin (inline)
		FM_INPLUGIN      = '★｛%s%s%s｝'
		RE_INPLUGIN      = /^★｛(#{TX_IDENT})(?:\#(\S+))(?:\s+(.+))?｝$/

		# indent
		RE_INDENT        = /^(　*)/

		# word
		RE_WORD          = /^([#{TX_WORD}]+)/

		# Plugin
		FM_PLUGIN_PRM    = " %s"
		RE_PLUGIN_PRM    = /^(?:\"((?:[^\"\\]|\\.)*)\"|(\S+))/
		FM_PLUGIN_HDC    = "＊%s"
		RE_PLUGIN_HDC    = /^＊(#{TX_IDENT})/
		FM_PLUGIN_SEP    = " "
		RE_PLUGIN_SEP    = /^\s+/

	end
end
