require 'vikiwikiplugin'
begin
require 'xpath-mini'
rescue LoadError
end

module VikiWiki
	module Plugins
		class Toc
			include BaseModule
			def ondesc; <<DSC; end
The plugin can show the table of contents.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['DMY_MAK'] = '_'

			def safe; 5 ; end
			def onview
				@toc_i = 0 unless @toc_i
				@toc_i += 1
				tag, attr, pos = @prms
				tag = tag ? /^#{Regexp::escape(tag)}$/ : /^h\d$/
				attr = attr ? attr.split(',') : []
				pos = pos || 'block'
				res = ''
				@sys.page.node.each_node(tag, attr) do |n|
					if defined?(Block) then
						is_inline = (not Block === n)
						has_child = n.have_text?
						ntype = n.type
					else
						is_inline = n.getAttribute('wiki-node-type') == 'inline'
						has_child = n.hasChildNodes
						ntype = n.nodeName
					end
					name = "toc%d" % @toc_i; @toc_i += 1
					prm_path = "plugin[@name='aname']/param/text()"
					if defined?(XPath) then
						xpath = XPath::new(prm_path)
						prm = xpath.eval(n)
					else
						prm = n.xpath(prm_path)
					end
					name = prm.to_a.first if prm
					level = /\d+/ === ntype ? $&.to_i : 1
					text = Parser::new(@sys).to_html(n, @sys.page.style)
					text.gsub!(/<[^>]+>/, '')
					text.gsub!(/\n/, '')
					res << ' '*(level-1)+"* [##{name} #{text}]\n"
					if defined?(Inline) then
						n.text << Inline::new('a', LBL['DMY_MAK'], {'name'=>name})
					else
						n.createElementSimply('a', {'name'=>name}, LBL['DMY_MAK'], true)
					end
				end
				return Parser::trans_html(@sys, res, 'VikiWikiStyle')
			end
		end
	end
end
