require 'vikiwikiplugin'
require 'grep'

module VikiWiki
	module Plugins
		class Search
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can search the keyword each page.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['KEY_WOD'] = 'Keyword'
			LBL['REG_EXP'] = 'RegularExpression'
			LBL['SRC_PAG'] = 'SearchPage'
			LBL['SHT_SRC'] = 'Search'
			LBL['GRP_REP'] = 'GrepReplace'
			MSG = Hash::new unless defined? MSG
			MSG['MTC_LIN'] = '%1 results matched.'
			MSG['NOT_FND'] = '%1 is not found.'
			MSG['FIN_REP'] = 'To replace lines finished.'
			MSG['FIN_UPD'] = '* [[%1]] is updated.'
			MSG['NOT_UPD'] = '* [[%1]] is not updated. (%2)'

			def safe; 4 ; end
			def onpost
				case @sys.cgi.params['search_mode'][0]
				when 'replace' then
					ftms = Hash::new
					@sys.cgi.params.each{|k, v|
						ftms[CGI::unescapeURI($')] = v[0] if /^page_/ === k
					}
					grep_replace(@sys.cgi.params['grep_replace'][0], ftms)
				end
				return nil
			end
			def onview
				keyword = @sys.cgi.params['keyword'][0]
				case @prms[0]
				when 'short' then
					return plugin_form({'p'=>SearchPage}, {}, false) {|recv|
						recv << text('keyword', keyword, 8)
						recv << submit('exec', LBL['SHT_SRC'])
					}
				else
					cols, rows = @prms
					cols, rows = 80, 20 unless cols and rows
				end
				rep = @sys.cgi.params['replace'][0] == 'on' ? true : false
				res = Array::new
				res << plugin_form({}, {}, false) {|recv|
					recv << LBL['KEY_WOD']
					recv << text('keyword', keyword)
					recv << checkbox('replace', 'on', rep)
					recv << LBL['GRP_REP']
					recv << submit('exec', LBL['SRC_PAG'])
				}
				if keyword then
					pages = Hash::new
					hit = 0
					Grep::grep(keyword, @sys['TEXTDIR'], "*.#{@sys['FILEEXT']}", @sys['GREPCMD']){|path, num, line|
						hit += 1
						file = path.sub(/^#{Regexp::escape(@sys['TEXTDIR'])}\//, '')
						name = file.split('.')[0]
						name = CGI::unescapeURI(name)
						pages[name] = Array::new unless pages.key?(name)
						pages[name] << [path, num, line]
					}
					if hit == 0 then
						res << CGI::element('p', nil, MSG['NOT_FND'].emb(keyword))
					elsif rep then
						hid = {'search_mode'=>'replace'}
						pages.keys.each{|name|
							hid["page_#{CGI::escapeURI(name,'')}"] =
								File::mtime(pages[name][0][0]).tms
						}
						text = pages.keys.sort.map{|name|
							pages[name].map{|file, num, line|
								"%s(%d): %s" % [name, num, line]
							}
						}
						text = (text << nil).join("\n")
						res << plugin_form(hid) {|recv|
							recv << textarea('grep_replace', text, cols, rows)
							recv << submit('exec', LBL['GRP_REP'])
						}
					else
						text = pages.keys.sort.map{|name|
							pages[name].map{|file, num, line|
								"+ [[%s]](%d): {{%s}}" % [name, num, line]
							}
						}
						text = (text << nil).join("\n")
						res << CGI::element('p', nil, MSG['MTC_LIN'].emb(hit.to_s))
						res << Parser::trans_html(@sys, text, 'VikiWikiStyle')
					end
				elsif @search_repres then
					# Output results of Grep Replace.
					res << CGI::element('p', nil, MSG['FIN_REP'])
					res << Parser::trans_html(@sys,
						@search_repres.join("\n"), 'VikiWikiStyle')
				end
				return res
			end
			def grep_replace(reps, ftms)
				res = Array::new
				prev_page = nil
				prev_cnt = nil
				ptext, style, path = nil
				reps.each{|line|
					case line.chomp
					when /^(.+)\((\d+)\): / then
						page, cnt, text = $1, $2.to_i, $'+"\n"
						next unless ftms[page]
						if page != prev_page then
							if prev_page then
								begin
									@sys.pages[prev_page].write(ptext.join, ftms[prev_page])
									res << MSG['FIN_UPD'].emb(prev_page)
								rescue
									res << MSG['NOT_UPD'].emb(prev_page, $!.to_s)
								end
							end
							ptext, style, path = @sys.pages[page].load
							ptext = ptext.to_a
							prev_cnt = 0
						end
						if prev_cnt == cnt then
							ptext[cnt-1] += text
						else
							ptext[cnt-1] = text
						end
					when /^(.+)\((\d+)\)$/ then
						page, cnt, text = $1, $2.to_i, nil
						ptext[cnt-1] = ''
					end
					prev_page = page
					prev_cnt = cnt
				}
				if prev_page then
					@sys.cgi.params['d'] = [ftms[prev_page]]
					begin
						@sys.pages[prev_page].write(ptext.join, ftms[prev_page])
						res << MSG['FIN_UPD'].emb(prev_page)
					rescue
						res << MSG['NOT_UPD'].emb(prev_page, $!)
					end
				end
				@search_repres = res
			end
		end
	end
end
