require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Schedule_Plan
			attr_reader :page, :title, :stime, :etime, :complete, :person, :cost, :note
			def initialize(page, plan)
				prms = plan.split(/\|\|/)
				prms.shift
				title, stime, etime, complete, person, cost, note = prms
				@page = page
				@title = title
				@stime = stime.to_t
				@etime = etime.to_t || @stime
				@complete = complete.to_i
				@person = person
				@cost = cost
				@note = note
			end
		end
		class Schedule
			include BaseModule
			def ondesc; <<DSC; end
The plugin can show a calender and a chart.
{{{
#schedule {chart|table|calender} {pages|plans} {max|now|date}
||title||stime||etime||complete||person||cost||note
}}}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['SCD_PAG'] = 'Page'
			LBL['SCD_TIT'] = 'Title'
			LBL['SCD_STM'] = 'StartDate'
			LBL['SCD_ETM'] = 'EndDate'
			LBL['SCD_CPL'] = 'Complete'
			LBL['SCD_PSN'] = 'Person'
			LBL['SCD_CST'] = 'Cost'
			LBL['SCD_NOT'] = 'Note'
			LBL['SCD_UPD'] = 'Update'

			REGEXP_PAGES = /^\/(.+)\/$/
			def safe; 5 ; end
			def onpost
				return unless old = @sys.cgi.params['schedule_line'][0]
				insert(old){
					[
						nil,
						@sys.cgi.params['schedule_title'],
						@sys.cgi.params['schedule_stime'],
						@sys.cgi.params['schedule_etime'],
						@sys.cgi.params['schedule_complete'],
						@sys.cgi.params['schedule_person'],
						@sys.cgi.params['schedule_cost'],
						@sys.cgi.params['schedule_note'],
					].join('||')
				}
			end
			def onview
				view, plans, range = @prms
				case view
				when 'calender' then
					calender_view(plans, range)
				when 'table' then
					table_view(plans)
				when 'form' then
					form_view(plans)
				else
					chart_view(plans, range)
				end
			end
		private
			def calender_view(plans, range)
				plans = parse_plan(plans)
				mon = @sys.cgi.params['schedule_date'][0]
				unless mon then
					case range
					when /^\d/ then
						mon = range
					else
						mon = Time::now.strftime('%Y-%m')
					end
				end
				mon = mon.to_t
				res = Array::new
				res << CGI::element('tr'){|recv|
					recv << move_month(mon.add(-1,'mon'), '<<')
					recv << CGI::element('th',{'colspan'=>5},mon.strftime('%Y-%m'))
					recv << move_month(mon.add(+1,'mon'), '>>')
				}
				res << CGI::element('tr'){|recv|
					n = Time::now
					(0..6).each{|i|
						t = n - (n.wday-i)*24*60*60
						recv << CGI::element('th', {'class'=>t.strftime('%A')}, weekdayname(t))
					}
				}
				scal = mon.add(-mon.wday)
				ecal = mon.add(1, 'mon')
				ecal = ecal.add((7-ecal.wday) % 7 - 1)
				scal.upto(ecal, 7){|ncal|
					res << CGI::element('tr'){|recv|
						ncal.upto(6){|n|
							td = ''
							if n.mon == mon.mon then
								td << n.day.to_s + "\n"
								plans.each{|plan|
									next if plan.stime.nil? or plan.etime.nil?
									td << "\n"+plan.title if plan.stime <= n and n <= plan.etime
								}
								td = Parser::trans_html(@sys, td)
							end
							recv << CGI::element('td', {'class'=>n.strftime('%A')}, td, true)
						}
					}
				}
				return CGI::element('table', {'class'=>'chart', 'border'=>1}, res, true)
			end
			def table_view(plans)
				Parser::trans_html(@sys,
					['SCD_TIT', 'SCD_STM', 'SCD_ETM', 'SCD_CPL', 'SCD_PSN', 'SCD_PLN', 'SCD_NOT'].map{|prm|
						"||''#{LBL[prm]}''"
					}.join + "\n" + plans
				)
			end
			def form_view(plans)
				res = Array::new
				head = ['SCD_TIT', 'SCD_STM', 'SCD_ETM', 'SCD_CPL', 'SCD_PSN', 'SCD_PLN', 'SCD_NOT'].map{|prm|
					LBL[prm]
				}
				plans.each{|plan|
					_, title, stime, etime, complete, person, cost, note = plan.split(/\|\|/)
					pp = Array::new
					pp << text('schedule_title', title, 20)
					pp << text('schedule_stime', stime, 12)
					pp << text('schedule_etime', etime, 12)
					pp << text('schedule_complete', complete, 8)
					pp << text('schedule_person', person, 12)
					pp << text('schedule_cost', cost, 8)
					pp << text('schedule_note', note, 20)
					pp << submit('exec', LBL['SCD_UPD'])
					res << plugin_form({'schedule_line'=>[UPDATE, plan.chomp].join(':')}){|recv|
						recv << head if head
						recv << pp
						head = nil
					}
				}
				to_table(res)
			end
			def chart_view(plans, range)
				plans = parse_plan(plans)
				ymd = Time::now.ymd
				min, max = nil, nil
				case range
				when /^\d/ then
					min, max = range.split(',').map{|x| x.to_t}
					max = min unless max
				when 'now' then
					now = @sys.cgi.params['schedule_date'][0]
					now = Time::now.strftime('%Y-%m-%d') unless now
					now = now.to_t
					min = now - 15*24*60*60
					max = now + 15*24*60*60
				else
					plans.each{|plan|
						min = plan.stime if plan.stime and (min.nil? or min > plan.stime)
						max = plan.etime if plan.etime and (max.nil? or max < plan.etime)
					}
				end
				return '' if min.nil? or max.nil?
				res = Array::new
				thead = CGI::element('tr'){|recv|
					recv << CGI::element('th', {'class'=>'page'}, LBL['SCD_PAG'])
					recv << CGI::element('th', {'class'=>'title'}, LBL['SCD_TIT'])
					recv << CGI::element('th', {'class'=>'person'}, LBL['SCD_PSN'])
					recv << move_month(min, '<<') if range == 'now'
					pmon = nil
					min.upto(max){|t|
						day = pmon == t.mon ? t.day.to_s : "#{t.mon}/#{t.day}"
						day = day.rjust(5).gsub(' ', '&nbsp;')
						pmon = t.mon
						cls = t.strftime('%A')
						cls = 'Today' if t.ymd == ymd
						recv << CGI::element('th', {'class'=>cls}){day}
					}
					recv << move_month(max, '>>') if range == 'now'
				}
				cnt = 0
				plans.each{|plan|
					wid = (max.to_i - min.to_i)/24/60/60 + 1
					lcols = (plan.stime.to_i - min.to_i)/24/60/60
					acols = mcols = (plan.etime.to_i - plan.stime.to_i)/24/60/60 + 1
					rcols = (max.to_i - plan.etime.to_i)/24/60/60
					lcols, mcols = 0, mcols + lcols if lcols < 0
					rcols, mcols = 0, mcols + rcols if rcols < 0
					lcols, mcols = wid, 0 if lcols > wid
					rcols, mcols = wid, 0 if rcols > wid
					next if range == 'now' and mcols == 0
					res << thead if cnt % 10 == 0
					res << CGI::element('tr'){|recv|
						recv << CGI::element('td', {'class'=>'page'}){@sys.page.name == plan.page.name ? '-' : Parser::trans_html(@sys, "[[#{plan.page.name}]]")}
						recv << CGI::element('td', {'class'=>'title'}){Parser::trans_html_inline(@sys, plan.title)}
						recv << CGI::element('td', {'class'=>'person'}){Parser::trans_html_inline(@sys, plan.person)}
						recv << CGI::element('td', nil, '') if range == 'now'
						0.upto(lcols-1) {|i|
							t = min + i*24*60*60
							cls = t.strftime('%A')
							cls = 'Today' if t.ymd == ymd
							recv << CGI::element('td', {'class'=>cls}){'&nbsp;'}
						}
						recv << CGI::element('td', {'colspan'=>mcols}){
							CGI::element('table', {'class'=>'result', 'width'=>'100%', 'title'=>plan.note}){
								CGI::element('tr'){|arr|
									cpl = plan.complete / (mcols/acols.to_f)
									arr << CGI::element('td', {'class'=>'end', 'width'=>"#{cpl}%"}){'&nbsp;'} if cpl > 0
									arr << CGI::element('td', {'class'=>'yet', 'width'=>"*"}){'&nbsp;'} if cpl < 100
								}
							}
						} if mcols > 0
						0.upto(rcols-1) {|i|
							t = min + (lcols+mcols+i)*24*60*60
							cls = t.strftime('%A')
							cls = 'Today' if t.ymd == ymd
							recv << CGI::element('td', {'class'=>cls}){'&nbsp;'}
						}
						recv << CGI::element('td', nil, '') if range == 'now'
					}
					cnt += 1
				}
				return CGI::element('table', {'class'=>'chart', 'border'=>1}){res}
			end
			def weekdayname(day)
				t.strftime('%a')
			end
			def parse_plan(plans)
				plans = plans.to_s
				scplans = Array::new
				if /^\|\|/ === plans then
					plans.each{|plan|
						scplans << Schedule_Plan::new(@sys.page, plan)
					}
				else
					if REGEXP_PAGES === plans then
						plans = Regexp::new($1)
						match = @sys.pages.names.select{|name| plans === name}
					else
						match = plans.split
					end
					match.each{|name|
						page = @sys.pages[name]
						page.node.each_node('plugin'){|plugin|
							next unless @name == plugin.attr['name']
							next unless plugin[1]
							next unless /^\|\|/ === plugin[1].text
							plugin[1].text.each{|plan|
								scplans << Schedule_Plan::new(page, plan)
							}
						}
					}
				end
				return scplans
			end
			def move_month(mon, mark)
				CGI::element('th', {'class'=>'link'}){
					CGI::element('a',
						{'href'=>@sys.page.uri({'schedule_date'=>mon.ymd})},
						mark)
				}
			end
		end
	end
end
