require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class List
			include BaseModule
			LIST_ITEM = ['page','alias','time','date','count']
			def ondesc; <<DSC; end
The system plugin can show the list of pages.
{{{
#list [target] [grpfmt] [format] [group] [order] [asc]
}}}
||target||The target to display is specified.
||grpfmt||Specify the format of the group item. It is the empty string "" when the group is not used.
||format||Specify the format of list item.
||group ||Specify the grouping item.
||order ||Specify the sorting item.
||asc   ||Specify "asc" or "desc". Default is "desc".

The 'target' is specified such as the following.
:number-of-rows:Specify the number of rows. It shows all of the case of zero or less.
:/regular-expression/:Specify the regular expression to filter each page name. Refer to Ruby's manual about the Regular Expression.
:/regular-expression/number-of-rows:It is the two above-mentioned combination. Specify the number of rows and the regular expression to filter.

The following can be used for the format, or the item of grouping and sorting.
'page','alias','time','date','count'

Since the specification method is complicated, please make the following examples reference.
+ default
 {{#list}}
+ group by date and Sort by time (same as default)
 {{#list 10 "!!!date" ":page(count):time" date time desc}}
+ for access counter
 {{#list 0 "" "*page(count)" "" count desc}}
+ all pages
 {{#list 0 "" "* {{page}} - page(count) time" "" page asc}}
- The following displays from a head five pages which start in Page in order of a name.
 {{#list /^Page/5 "" "*page" "" page asc}}
DSC

			def safe; 5 ; end
			def onview
				rows, grpfmt, format, group, order, asc = @prms
				if /^\/(.+)\/(\d*)$/ === rows then
					rows, regexp = $2.to_i, /#{$1}/
				else
					rows, regexp = rows.to_i, nil
				end
				sty = @sys.style
				if grpfmt.nil? or format.nil? then
					grpfmt = "!!!date" unless grpfmt
					format = ":[[page]](count):time" unless format
					sty = 'VikiWikiStyle'
				end
				group = 'date' unless group
				order = 'time' unless order
				asc = asc=='asc' ? +1 : -1
				arr = Array::new
				@sys.pages.elements.each{|path, name, style, user, extension|
					next if regexp and not regexp === name
					next if @sys.static? and not @sys.pages[name].static.exist?
					ftime = File::mtime(path)
					tms = ftime.tms if ftime
					ymd = ftime.ymd if ftime
					count = @sys.counter[name].to_i
					arr << {
						'page' => name,
						'alias' => @sys.aliases.get(name),
						'time' => tms,
						'date' => ymd,
						'count' => count,
					}
				}
				arr.sort!{|a,b|
					(a[order].nil? ? -1 : b[order].nil? ? +1 : a[order] <=> b[order]) * asc
				}
				arr = arr[0,rows] if rows > 0

				has = Hash::new
				arr.each{|x|
					k = x[group]
					has[k] = Array::new unless has.key?(k)
					has[k] << x
				}
				res = Array::new
				grp = has.to_a.sort{|a,b|
					(a[0] <=> b[0]) * asc
				}.each{|k,v|
					res << grpfmt.replace_words(v[0]) unless grpfmt.empty?
					v.each{|x|
						res << format.replace_words(x)
					}
				}
				return Parser::trans_html(@sys, res.join("\n"), sty)
			end
		end
	end
end
