require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Index
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can create the indexes.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['DEL_IDX'] = 'DeleteIndex'
			LBL['INI_NAM'] = 'Initial'
			LBL['REG_IDX'] = 'RegistIndex'
			LBL['RFR_IDX'] = 'RefreshIndex'
			LBL['WOD_NAM'] = 'Word'

			def safe; 3 ; end
			def onpost
				case @sys.cgi.params['index_mode'][0]
				when 'add' then
					ini = @sys.cgi.params['index_new'][0]
					ini = @sys.cgi.params['index_ini'][0] if ini.empty?
					word = @sys.cgi.params['index_word'][0]
					return if ini.to_s.empty? or word.to_s.empty?
					pages = Hash::new
					@sys.pages.each{|page|
						i = 1
						File::foreach(page.path){|line|
							if line.include?(word) then
								pages[page.name] = Array::new unless pages.key?(page.name)
								pages[page.name] << i
							end
							i += 1
						}
					}
				when 'del' then
					ini, word = @sys.cgi.params['index_iniword'][0].split('/', 2)
					pages = nil
				end
				@sys.indexes.update(ini, word, pages)
				@sys.static_update
			end
			def onview
				indexes = @sys.indexes
				res = Array::new
				res << maintainform(indexes)
				inis = indexes.datas.keys.sort
				inis.each_with_index{|ini, i|
					res << CGI::element('a', {'href'=>"#idx#{i}"}, ini)
				}
				inis.each_with_index{|ini, i|
					words = indexes.datas[ini]
					res << CGI::element('h2'){CGI::element('a', {'name'=>"#idx#{i}"}, ini)}
					dl = Array::new
					res << CGI::element('dl') do |dl|
						words.to_a.sort.each do |word, links|
							dl << CGI::element('dt', nil, word)
							dl << CGI::element('dd') do |dd|
								links.each do |link|
									page = @sys.pages[link[0]]
									dd << CGI::element('a', {'href'=>page.uri}, page.name)
								end
							end
						end
					end
				}
				return res
			end
			def maintainform(indexes)
				res = Array::new
				inis = indexes.datas.keys.sort
				inis.unshift(['','new-->'])
				res << plugin_form({'index_mode'=>'add'}){|recv|
					recv << [
						LBL['INI_NAM'],
					 	select('index_ini', nil, inis)+
					 	text('index_new', '', 5)
					]
					recv << [
						LBL['WOD_NAM'],
						text('index_word', '', 40),
						nil
					]
					recv << [
						submit('exec', LBL['REG_IDX']),
						nil
					]
				}
				words = indexes.datas.sort.map{|i,v|
					v.sort.map{|w,p| "#{i}/#{w}"}
				}.flatten
				res << plugin_form({'index_mode'=>'del'}){|recv|
					recv << [
						"#{LBL['INI_NAM']}/#{LBL['WOD_NAM']}",
					 	select('index_iniword', nil, words),
						submit('exec', LBL['DEL_IDX']),
					]
				}
				return res
			end
		end
	end
end
