require 'vikiwikiplugin'
require 'vikiwikiattach'

module VikiWiki
	module Plugins
		class Attach
			include BaseModule
			def ondesc; <<DSC; end
The plugin can upload the attached file.
{{{
#attach
}}}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['ATT_FIL'] = 'AttachedFile'
			LBL['UPL_FIL'] = 'UploadFile'
			LBL['REM_FIL'] = 'RemoveFile'
			LBL['CUR_DIR'] = 'PageDirectory'

			def safe; 3 ; end
			def onpost
				return unless dir = getmydir
				dir.create
				file = @sys.cgi.params['attach_file'][0]
				case @sys.cgi.params['attach_mode'][0]
				when 'add' then
					dir.put(file)
				when 'del' then
					dir[file].drop
				end
				@sys.static_update
			end
			def onview
				return unless dir = getmydir
				if /^file:/ === @sys['ATTACHURI'] then
					# file:// mode
					dir.create
					res = Array::new
					res << CGI::element('p'){LBL['CUR_DIR']+' '+dir.link}
					res << CGI::bgntag('ul')
					dir.each do |file|
						res << CGI::element('li'){file.link}
					end
					res << CGI::endtag('ul')
					return res
				end
				res = Array::new
				res << multipart_plugin_form({'attach_mode'=>'add'}) do
					[
						LBL['ATT_FIL'],
						file('attach_file'),
						submit('exec',LBL['UPL_FIL'])
					].join("\n")
				end
				files = Array::new
				dir.each_file do |file|
					files << [
						radio('attach_file', file.name),
						file.link
					]
				end
				unless files.empty? then
					res << plugin_form({'attach_mode'=>'del'}) do |recv|
						recv += files
						recv << [submit('exec', LBL['REM_FIL']), nil]
					end
				end
				return res
			end
		private
			def getmydir
				return nil unless @sys['ATTACHDIR']
				return nil unless @sys['ATTACHURI']
				dir = VikiWiki::Attach::new(@sys.page.name,
					@sys['ATTACHDIR'], @sys['ATTACHURI'], true,
					@sys.encoding, @sys['OSCODE'])
				dir.name = @sys.page.alias
				return dir
			end
		end
	end
end
