require 'extension/time'
require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Alias
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can regist the AliasName.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['ALL_UPD'] = 'AllUpdate'
			LBL['ALS_NAM'] = 'AliasName'
			LBL['DEL_ALS'] = 'DeleteAlias'
			LBL['PAG_NAM'] = 'PageName'
			LBL['REG_ALS'] = 'RegistAlias'

			def safe; 3 ; end
			def onpost
				time = nil
				case @sys.cgi.params['alias_mode'][0]
				when 'add' then
					page = @sys.cgi.params['page'][0]
					palias = @sys.cgi.params['alias'][0]
					return unless page and palias
					@sys.aliases[page] = palias
				when 'del' then
					@sys.aliases.delete(@sys.cgi.params['del'][0])
				when 'all' then
					aliases = @sys.aliases.datas
					@sys.cgi.params.each{|k,v|
						next unless /^alias_p_/ === k
						page = CGI::unescapeURI($')
						palias = v[0]
						if palias.to_s.empty? then
							aliases.delete(page) if aliases.key?(page)
						else
							aliases[page] = palias
						end
					}
					@sys.aliases.replace(aliases)
					time = Time::parse(@sys.cgi.params['alias_time'][0])
				end
				@sys.aliases.update(time)
			end
			def onview
				case @prms[0]
				when 'all' then allform
				when 'add' then addfrom
				when 'del' then delform
				else [addform, delform, allform]
				end
			end
			def addform
				plugin_form({'alias_mode'=>'add'}) {|recv|
					recv << [LBL['PAG_NAM'], text('page', '')]
					recv << [LBL['ALS_NAM'], text('alias', '', 40)]
					recv << [submit('exec', LBL['REG_ALS']), nil]
				}
			end
			def delform
				unless @sys.aliases.empty? then
					plugin_form({'alias_mode'=>'del'}) {|recv|
						@sys.aliases.each{|page, als|
							recv << [radio('del', page, false, page), als]
						}
						recv << [submit('exec', LBL['DEL_ALS']), nil]
					}
				end
			end
			def allform
				aliases = @sys.aliases.datas
				tms = @sys.aliases.mtime ? \
					@sys.aliases.mtime.tms : ''
				plugin_form({'alias_time'=>tms, 'alias_mode'=>'all'}) {|recv|
					aliases.sort.each{|page, als|
						aln = "alias_p_#{CGI::escapeURI(page,'')}"
						recv << [page, text(aln, als)]
					}
					@sys.pages.names.each{|name|
						next if aliases.key?(name)
						aln = "alias_p_#{CGI::escapeURI(name,'')}"
						recv << [name, text(aln, '')]
					}
					recv << [submit('exec', LBL['ALL_UPD']), nil]
				}
			end
		end
	end
end
