module TransText
	POSITIONS = [
		TOP    = 'top',
		BOTTOM = 'bottom',
		FRONT  = 'front',
		BACK   = 'back',
		UPDATE = 'update'
	]
	def TransText::insert(source, target, position, pattern)
		case position
		when TOP then
			return target + source
		when BOTTOM then
			return source + target
		end
		res = ''
		source.each do |line|
			match = pattern === line.chomp
			line = target.chomp+"\n" if match and position == UPDATE
			res << target if match and position == FRONT
			res << line
			res << target if match and position == BACK
		end
		return res
	end
	def TransText::delete(source, pattern)
		source.to_a.delete_if{|line| pattern === line.chomp}.join
	end
	def TransText::grep(source, pattern, add_number=false, filename=nil)
		res = ''
		source.each_with_index do |line, no|
			next unless pattern === line
			res << filename if filename
			res << "(%d): " % no if add_number
			res << line
		end
		return res
	end
end
