require 'uniquefile'

module DiffTool
	def DiffTool::executeDiff(file1, file2, resfile=nil)
		text = nil
		tmpfile = resfile || UniqueFie::tmpnam('diff')
		cmd = "diff \"#{file1}\" \"#{file2}\" 1> \"#{tmpfile}\" 2> \"#{tmpfile}.err\""
		cmd.gsub!(/\//,'\\') if /^[A-Za-z]:\\/ === ENV['WINDIR']
		begin
			system(cmd)
			File::unlink(tmpfile) if File::stat(tmpfile).size == 0
			text = File::readlines(tmpfile).join if File::exist?(tmpfile) and File::stat(tmpfile).size > 0
		ensure
			File::unlink("#{tmpfile}.err") if File::exist?("#{tmpfile}.err")
			File::unlink(tmpfile) if resfile.nil? and File::exist?(tmpfile)
		end
		return text
	end
	def DiffTool::attachDiff(lines, diflines)
		DiffTool::mergeDiff(lines, diflines, 'asc')
	end
	def DiffTool::detachDiff(lines, diflines)
		DiffTool::mergeDiff(lines, diflines, 'desc')
	end
	def DiffTool::mergeDiff(lines, diflines, odr='asc', opt='apply')
		# opt
		#  apply - The differences are exactly applied.
		#  merge - The deleted lines are not deleted.
		#  refer - The result has the marks < and > at the differences.
		lines = lines.to_a if lines.class != Array
		asc = odr != 'desc'
		s1, s2, m, t1, t2 = nil
		diflines.each do |ds|
			case ds
			when /^(\d+),?(\d+)?([adc])(\d+),?(\d+)?$/ then
				s1, s2, m, t1, t2 = $1.to_i, $2.to_i, $3, $4.to_i, $5.to_i
				s2 = s1 if s2 == 0
				t2 = t1 if t2 == 0
				s1 -= 1; s2 -= 1; t1 -= 1; t2 -= 1;
				case opt
				when 'merge' then
				else
					if asc then
						lines.fill('', s1..s2) if m == 'c' or m == 'd'
					else
						lines.fill('', t1..t2) if m == 'c' or m == 'a'
					end
				end
			when /^< / then
				if opt == 'refer' then
					lines[t1] += (asc ? '< ' : '> ') + $'
				elsif not asc then
					lines[t1] += $'
				end
			when /^> / then
				if opt == 'refer' then
					lines[s1] += (asc ? '> ' : '< ') + $'
				elsif asc then
					lines[s1] += $'
				end
			when /^-+$/ then
			end
		end
		return lines.join
	end
	def DiffTool::mergeText(text1, text2)
		begin
			file1 = UniqueFie::tmpnam('diff')
			file2 = UniqueFie::tmpnam('diff')
			File::open(file1, "w") do |f|
				f.write(text1)
			end
			File::open(file2, "w") do |f|
				f.write(text2)
			end
			diflines = DiffTool::executeDiff(file1, file2)
			return text1 unless diflines
			return DiffTool::mergeDiff(text1, diflines, 'asc', 'merge')
		ensure
			File::unlink(file1) if File::exist?(file1)
			File::unlink(file2) if File::exist?(file2)
		end
	end
end
