require 'extension/time'
require 'istore'

class CryptPassword
	KEYLEN = 16
	attr_reader :user
	def initialize(dir)
		@fpass = "#{dir}/passwd"
		@fsess = "#{dir}/session"
		@passwd = Hash::new
		File::foreach(@fpass){|line|
			user, crypt, salt = line.chomp.split(':')
			@passwd[user] = [crypt, salt]
		} if File::exist?(@fpass)
	end
	def update(user, oldpass, newpass)
		raise "authorization failed" \
			if @passwd.key?(user) and \
				not authenticate(user, oldpass)
		salt = genkey
		crypt = newpass.crypt(salt)
		@passwd[user] = [crypt, salt]
		text = @passwd.to_a.map{|x| x.flatten.join(':')}.join("\n")+"\n"
		File::fwrite(@fpass, text)
	end
	def delete(user, pass)
		raise "authorization failed" unless authenticate(user, pass)
		@passwd.delete(user)
		text = @passwd.to_a.map{|x| x.flatten.join(':')}.join("\n")
		File::fwrite(@fpass, text)
	end
	def deletef(pass, user)
		raise "authorization failed" unless authenticate('vikiwiki', pass)
		@passwd.delete(user)
		text = @passwd.to_a.map{|x| x.flatten.join(':')}.join("\n")
		File::fwrite(@fpass, text)
	end
	def basic_auth
		env = ENV['HTTP_AUTHORIZATION']
		if /^Basic /i === env then
			user, pass = $'.unpack("m").first.split(':')
			return authenticate(user, pass)
		end
		return nil
	end
	def authenticate(user, pass)
		return false if user.nil? or pass.nil?
		return false if user.empty? or pass.empty?
		tcrypt, tsalt = @passwd[user]
		if tsalt then
			return false unless tcrypt
			fcrypt = pass.crypt(tsalt)
			return false if fcrypt != tcrypt
		else
			return false if pass != tcrypt
		end
		@user = user
		return true
	end
	def get_session(tms, id, user=nil, pass=nil, timeout=600)
		cok = IStore::new(@fsess, []).read
		ncok = Array::new
		res = nil
		ntms, nid = (Time::now+timeout).tms, genkey
		cok.each{|t,i,u|
			next if Time::parse(t) < Time::now
			ncok << [t, i, u]
			if t==tms and i==id then
				@user = u
				res = [ntms, nid, u]
				ncok << res
			end
		}
		if @user.nil? and authenticate(user, pass) then
			@user = user
			res = [ntms, nid, user]
			ncok << res
		end
		IStore::new(@fsess, []).write(ncok)
		return *res
	end
private
	def genkey
		keys = Array::new
		0.upto(KEYLEN){|i| keys << rand(64)}
		return keys.pack("C*").tr("\x00-\x3f","A-Za-z0-9./")
	end
end
