require 'dom-mini'
require 'xmlparser-mini'

module VikiWikiBuiltin
	#===========================================
	# The method calls when the system is setup.
	#===========================================
	def onsetup
		# DOM object
		@xml = Document::new(DOMImplementation::instance)
		# XML parser
		@xmlparser = XMLParser::new
		# CVS object
		if @conf['CVSROOT'] then
			require 'cvswrapper'
			@cvs = CVSwrapper::new(@conf['CVSROOT'], File::dirname(@basedir.chomp('/')))
		else
			require 'diffcvs'
			@cvs = DiffCVS::new(@conf['FILEMODE'].oct, @conf['BACKUP'])
		end
	end
	#===========================================
	# The method calls when a page is updated.
	#===========================================
	def onwrite(page)
	end
end
