module Log
	@@flog = nil
	@@plog = nil
	def Log::out(name, *vals)
		unless @@flog then
			@@flog = File::open("debug.log", "w")
			@@flog.puts("*** PID:%d, TIME:%s ***" % [$$, Time::now.strftime("%Y-%m-%d %H:%M:%S")])
		end
		now = Time::now
		@@flog.puts("--- %s %s.%06d ---" % [name, now.strftime("%Y-%m-%d %H:%M:%S"), now.usec])
		@@flog.puts(*vals)
		@@flog.flush
	end
	def Log::perform(src, line)
		@@plog = File::open("perform.log", "w") unless @@plog
		now = Time::now
		@@plog.printf("%s.%06d\t%s(%d)\n", now.strftime("%Y-%m-%d %H:%M:%S"), now.usec, src, line)
	end
	def Log::rescue(*vals)
		lines = Array::new
		if File::exist?("rescue.log") then
			lines = File::readlines("rescue.log")
			lines = lines[-1, 1000] if lines.size > 1000
		end
		File::open("rescue.log", "w") do |flog|
			flog.write(lines.join)
			flog.puts("*** PID:%d, TIME:%s ***" % [$$, Time::now.strftime("%Y-%m-%d %H:%M:%S")])
			now = Time::now
			flog.puts("--- %s %s.%06d ---" % [name, now.strftime("%Y-%m-%d %H:%M:%S"), now.usec])
			flog.puts(*vals)
		end
	end
end
