module LockFile
	LOKDIR = '.lok'
	def LockFile::lock(*files)
		locks = Array::new
		files.flatten.each do |file|
			dir, base = File::split(file)
			lokdir = "#{dir}/#{LOKDIR}"
			Dir::mkdir(lokdir) unless File::exist?(lokdir)
			lokfile = "#{lokdir}/#{base}"
			begin
				locks << File::open(lokfile.untaint, "w")
				locks.last.flock(File::LOCK_EX|File::LOCK_NB)
			rescue LockFileTimeoutError
				raise "fail to lock file."
			end
		end
		if iterator? then
			begin
				yield
			ensure
				LockFile::unlock(locks)
			end
		else
			return locks
		end
	end
	def LockFile::unlock(*locks)
		locks.flatten.each do |lock|
			lock.flock(File::LOCK_UN)
			lock.close
		end
	end
end
