require 'ftools'

class Usage < StandardError; end

def cnvprint(str)
	if @cnv then
		@fout.print @cnv.call(str)
	else
		@fout.print str
	end
end

@fout = STDOUT

begin
	flags = Hash::new
	while /^\-/ === ARGV.first do
		$'.scan(/./){|c|
			case c
			when 'u' then
				flags['update'] = true
			when 'e' then
				flags['exist'] = true
			when 'x' then
				flags['index'] = true
			when 'i' then
				flags['img'] = true
			when 't' then
				flags['theme'] = true
			when 'l' then
				flags['link'] = true
			when 'd' then
				flags['delete'] = true
			when 'q' then
				flags['quiet'] = true
			when 'o' then
				ARGV.shift
				file = ARGV.first
				@fout = File::open(file.untaint, "w")
			when 'S', 'E', 'U' then
				flags['code'] = c.downcase
			else
				raise Usage
			end
		}
		ARGV.shift
	end
	raise Usage if ARGV.size < 2

	local = File::expand_path(ARGV.shift)
	script_name = ARGV.shift
	staticdir = ARGV.shift

	ENV['REQUEST_METHOD'] = 'GET'
	ENV['QUERY_STRING'] = ''
	ENV.reject{|key, value| /^HTTP/ === key}

	load(local)
	conf = {'SCRIPT_NAME' => script_name}
	conf.update(@conf)
	conf['STATICDIR'] = staticdir if staticdir
	File::mkpath(conf['STATICDIR'])

	require 'vikiwikisys'
	sys = VikiWiki::Sys::new(local, conf)
	sys.setup

	@cnv = USEconv::cnvmethod($KCODE, flags['code'])
	@cnv = USEconv::cnvmethod($KCODE, sys['OSCODE']) unless @cnv

	if flags['delete'] then
		unless flags['quiet'] then
			cnvprint "All HTMLs in #{sys['STATICDIR']} will be deleted. Are you sure? (yes/no) "
			flags['delete'] = false if STDIN.gets.chomp != 'yes'
		end
	end

	cnvprint "Start time "
	cnvprint Time::now.strftime('%Y-%m-%d %H:%M:%S')
	cnvprint "\n"

	if flags['delete']
		cnvprint "Delete all static HTMLs ... "
		sys.statics.delete_all
		sys.statics.generate_location_all
		cnvprint "finished.\n"
	end

	if flags['index'] then
		cnvprint "Generate index.html ... "
		sys.statics.generate_index_html
		cnvprint "finished.\n"
	end
	if flags['img'] then
		cnvprint "Copy img directory ... "
		sys.statics.copy_image
		cnvprint "finished.\n"
	end
	if flags['theme'] then
		cnvprint "Copy theme directory ... "
		sys.statics.copy_theme
		cnvprint "finished.\n"
	end

	if flags['link'] then
		sys.statics.generate(sys['TOPPAGE'], flags, method(:cnvprint))
	elsif ARGV.empty? then
		sys.pages.each{|page|
			sys.statics.generate(page, flags, method(:cnvprint))
		}
	else
		ARGV.each{|page|
			sys.statics.generate(page, flags, method(:cnvprint))
		}
	end

	cnvprint "End time "
	cnvprint Time::now.strftime('%Y-%m-%d %H:%M:%S')
	cnvprint "\n"

rescue Usage
	@fout.print <<ERROR
Usage: ruby static.rb [options] local-path script-name [targets]
local-path  : Specify the local path of the CGI script.
script-name : Specify the script name of the CGI script.
targets     : index, theme, image, all, link or page-names
options
  -u        : If the page is updated, the static HTML coresponding the page is generated.
  -e        : The static HTML is generated only if the static HTML exists.
  -t        : The theme directory is copied.
  -i        : The img directory is copied.
  -x        : The index.html is generated.
  -l        : The pages linked from the top page are generated.
  -d        : All static HTMLs are deleted before they are generated.
  -q        : The command is performed on silent mode.
  -S,-E,-U  : S = Shift_JIS, E = euc-jp, U = utf-8
  -o file   : The results are output to the file.
ERROR

ensure
	@fout.close if @fout != STDOUT
end
