# VikiWiki installed directory *** edit ***
$VIKIWIKIDIR="/home/vikiwiki/vikiwiki2/vikiwiki"
# Temporary directory *** edit ***
$VIKIWIKITMP="/home/vikiwiki/tmp"
# Ruby's path *** edit ***
$VIKIWIKIRUBY="/usr/bin/ruby"
# Use the wiki links on VikiWiki. *** edit ***
$VIKIWIKIUSEWIKILINK = true
# Use the plugins on VikiWiki. *** edit ***
$VIKIWIKIUSEPLUGIN = true

# Configurations
VIKIWIKICONF = {
# Specify the encoding on VikiWiki. *** edit ***
'ENCODING'    => 'utf-8',
# Specify the encoding on tDiary. *** edit ***
'TDIARY_ENCODING' => 'euc-jp',
# Specify the style using on VikiWiki. *** edit ***
'STYLE_NAME'  => 'VikiWiki',
# Specify the extension of pages on VikiWiki. *** edit ***
'FILEEXT'     => 'txt',
# Specify the script name of VikiWiki. *** edit ***
'SCRIPT_NAME' => '/index.cgi',
# Specify the script name of VikiWiki. *** edit ***
'LOCAL_FILE'  => '/home/vikiwiki/www/index.cgi',
# Specify the page name to store diary. *** edit ***
# - If you store the diary monthly, use format %Y%m.
# - If you store the diary daily, use format %Y%m%d.
'TD2PAGE'     => "MyDiary/MyPage%Y%m%d",   # each day
'TDCPAGE'     => "MyDiary/MyComment%Y%m",  # each month
'TDRPAGE'     => "MyDiary/MyReferer%Y%m",  # each month
# Top of heading
'HNTOP'       => 3,
}

# Auto-setting
File::foreach(VIKIWIKICONF['LOCAL_FILE']){|line|
	next unless /^[\"\']([^\"\']+)[\"\']\s*=>\s*(.+),$/ === line
	VIKIWIKICONF[$1] = eval($2) unless VIKIWIKICONF.key?($1)
}
VIKIWIKICONF['BASEDIR'] = File::dirname(VIKIWIKICONF['LOCAL_FILE']) unless VIKIWIKICONF['BASEDIR']
VIKIWIKICONF['BASEURI'] = File::dirname(VIKIWIKICONF['SCRIPT_NAME']) unless VIKIWIKICONF['BASEURI']

# Specify the page format to store the tDiary data into VikiWiki.
case VIKIWIKICONF['STYLE_NAME']
when 'AsWiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\|\|(\S+)\|\|(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) \[mailto\:(\S*) (\S*)\] (\S*)$/,
		'CMT_HEAD_FORMAT' => "||%s||%s [mailto:%s %s] %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^\|\|([^\|]+)\|\|([^\|]+)/,
		'HEAD_FORMAT'     => "||%s||%s",
		'REF_REGEXP'      => /^\|\|([^\|]+)\|\|([^\|]+)\|\|([^\|]+)/,
		'REF_FORMAT'      => "||%s||%s||%s",
	}
when 'FreeStyleWiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) mailto\:(\S*) (\S*) (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s mailto:%s %s %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^,([^,]+),([^,]+)/,
		'HEAD_FORMAT'     => ",%s,%s",
		'REF_REGEXP'      => /^,([^,]+),([^,]+),([^,]+)/,
		'REF_FORMAT'      => ",%s,%s,%s",
	}
when 'Hiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) mailto\:(\S*) (\S*) (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s mailto:%s %s %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^\*\|\|([^\|]+)\|\|([^\|]+)/,
		'HEAD_FORMAT'     => "*||%s||%s",
		'REF_REGEXP'      => /^\*\|\|([^\|]+)\|\|([^\|]+)\|\|([^\|]+)/,
		'REF_FORMAT'      => "*||%s||%s||%s",
	}
when 'PukiWiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) mailto\:(\S*) (\S*) (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s mailto:%s %s %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^\|([^\|]+)\|([^\|]+)/,
		'HEAD_FORMAT'     => "|%s|%s",
		'REF_REGEXP'      => /^\|([^\|]+)\|([^\|]+)\|([^\|]+)/,
		'REF_FORMAT'      => "|%s|%s|%s",
	}
when 'Tiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) mailto\:(\S*) (\S*) (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s mailto:%s %s %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^   \*\|\|([^\|]+)\|\|([^\|]+)/,
		'HEAD_FORMAT'     => "   *||%s||%s",
		'REF_REGEXP'      => /^   \*\|\|([^\|]+)\|\|([^\|]+)\|\|([^\|]+)/,
		'REF_FORMAT'      => "   *||%s||%s||%s",
	}
when 'YukiWiki' then
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) mailto\:(\S*) (\S*) (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s mailto:%s %s %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^,([^,]+),([^,]+)/,
		'HEAD_FORMAT'     => ",%s,%s",
		'REF_REGEXP'      => /^,([^,]+),([^,]+),([^,]+)/,
		'REF_FORMAT'      => ",%s,%s,%s",
	}
else
	VIKIWIKIFORMAT = {
		'CMT_HEAD_REGEXP' => /^\:(\S+)\:(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) \[mailto\:(\S*) (\S*)\] (\S*)$/,
		'CMT_HEAD_FORMAT' => ":%s:%s [mailto:%s %s] %s",
		'CMT_BODY_REGEXP' => /^ (.+)$/,
		'CMT_BODY_FORMAT' => " %s",
		'SEP'             => '-' * 10,
		'HEAD_REGEXP'     => /^\|\|([^\|]+)\|\|([^\|]+)/,
		'HEAD_FORMAT'     => "||%s||%s",
		'REF_REGEXP'      => /^\|\|([^\|]+)\|\|([^\|]+)\|\|([^\|]+)/,
		'REF_FORMAT'      => "||%s||%s||%s",
	}
end

# Set path
$: << $VIKIWIKIDIR
$: << $VIKIWIKIDIR+'/lib'

# Methods to convert the codeset.
require 'useconv'
VIKIWIKICONV = {
'STORE' => USEconv::cnvmethod(VIKIWIKICONF['TDIARY_ENCODING'], VIKIWIKICONF['ENCODING']),
'RESTORE' => USEconv::cnvmethod(VIKIWIKICONF['ENCODING'], VIKIWIKICONF['TDIARY_ENCODING'])
}
# Use wiki links
if $VIKIWIKIUSEWIKILINK then
	# Use the system of VikiWiki.
	require 'vikiwikisys'
else
	# Use the tDiary compatible system.
	module VikiWiki
		class Sys
			def initialize(local_file, conf)
			end
			def setup
			end
			def wri_onview(name, text=nil)
				if not name.include?(':') and VIKIWIKICONF['SCRIPT_NAME'] then
					"<a href=\"#{VIKIWIKICONF['SCRIPT_NAME']}?p=#{name}>#{text || name}</a>"
				else
					text || name
				end
			end
			def text_onview(text)
				text
			end
		end
		class HtmlGenerator
			def wikiname_onhtml(node, outobj='')
				name = node.getAttribute('wri')
				text = node.getTextValues.to_s
				if not name.include?(':') and VIKIWIKICONF['SCRIPT_NAME'] then
					"<a href=\"#{VIKIWIKICONF['SCRIPT_NAME']}?p=#{name}>#{text || name}</a>"
				else
					text || name
				end
			end
			def _text_onhtml(node, outobj='')
				node.getTextValues.to_s
			end
		end
	end
end
# Use tDiary's plugin
unless $VIKIWIKIUSEPLUGIN then
	module VikiWiki
		class Sys
			def plugin_onview(name, id=nil, prms=[], plain='', inline=false)
				pp = prms.map{|p| p.inspect}.join(', ') unless prms.empty?
				return ["<%= #{name}", pp, "%>"].compact.join(' ')
			end
		end
	end
end
