/*
 * Decompiled with CFR 0.152.
 */
package jp.techlier.extra.velocity.directive;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import jp.techlier.extra.velocity.directive.DirectiveUtils;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.parser.node.Node;

public class Import
extends InputBase {
    public String getName() {
        return "import";
    }

    public int getType() {
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        DirectiveUtils util = new DirectiveUtils((Directive)this, this.rsvc, context, node);
        int numChildren = node.jjtGetNumChildren();
        if (numChildren == 0) return util.error("invalid argument count");
        if (numChildren > 2) {
            return util.error("invalid argument count");
        }
        if (context.getTemplateNameStack().length >= this.rsvc.getInt("directive.parse.max.depth", 20)) {
            return util.error("max recursion depth reached: " + Arrays.asList(context.getTemplateNameStack()));
        }
        String templateName = util.getStringArgument(0);
        if (!templateName.startsWith("/")) {
            File currentTemplatePath = new File(context.getCurrentTemplateName());
            templateName = new File(currentTemplatePath.getParentFile(), templateName).getPath();
        }
        try {
            Template importingTemplate = this.rsvc.getTemplate(templateName, this.getInputEncoding(context));
            try {
                try {
                    context.pushCurrentTemplateName(templateName);
                    ((Node)importingTemplate.getData()).render(context, writer);
                    return true;
                }
                catch (Exception e) {
                    boolean bl = util.error("import error", e);
                    context.popCurrentTemplateName();
                    return bl;
                }
            }
            finally {
                context.popCurrentTemplateName();
            }
        }
        catch (Exception e) {
            return util.error("import error", e);
        }
    }
}

