/*
 * Decompiled with CFR 0.152.
 */
package jp.techlier.extra.velocity.directive;

import java.io.Writer;
import jp.techlier.commons.lang.reflect.ReflectUtils;
import jp.techlier.extra.velocity.directive.DirectiveUtils;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;

public class Defconst
extends Directive {
    public String getName() {
        return "defconst";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) {
        DirectiveUtils util = new DirectiveUtils(this, this.rsvc, context, node);
        if (node.jjtGetNumChildren() != 2) {
            return util.error("invalid argument count");
        }
        Node referenceNameNode = node.jjtGetChild(0);
        if (referenceNameNode.getType() != 16) {
            return util.error("first argument must be a reference");
        }
        String referenceName = ((ASTReference)referenceNameNode).getRootString();
        if (!context.containsKey((Object)referenceName)) {
            this.attachContextValueHandlingContext(context);
            context.put(referenceName, (Object)new ConstantValue(node.jjtGetChild(1).value(context)));
        }
        return true;
    }

    private void attachContextValueHandlingContext(InternalContextAdapter context) {
        if (context == null) {
            return;
        }
        if (context instanceof InternalContextAdapterImpl) {
            Object obj = ReflectUtils.get(context, "context");
            if (!(obj instanceof ConstantValueHandlingContext)) {
                ReflectUtils.set(context, "context", (Object)new ConstantValueHandlingContext(this.rsvc, (Context)obj));
            }
        } else if (context != context.getBaseContext()) {
            this.attachContextValueHandlingContext(context.getBaseContext());
        }
    }

    private static class ConstantValue {
        final Object value_;

        public ConstantValue(Object value) {
            this.value_ = value;
        }
    }

    private static class ConstantValueHandlingContext
    implements Context {
        private final RuntimeServices runtimeServices_;
        private final Context context_;

        ConstantValueHandlingContext(RuntimeServices runtimeServices, Context context) {
            this.runtimeServices_ = runtimeServices;
            this.context_ = context;
        }

        public Object put(String key, Object value) {
            if (this.context_.get(key) instanceof ConstantValue) {
                this.runtimeServices_.getLog().debug((Object)("cannot overwrite constant value: " + key));
                return null;
            }
            return this.context_.put(key, value);
        }

        public Object get(String key) {
            Object value = this.context_.get(key);
            if (value instanceof ConstantValue) {
                value = ((ConstantValue)value).value_;
            }
            return value;
        }

        public boolean containsKey(Object key) {
            return this.context_.containsKey(key);
        }

        public Object[] getKeys() {
            return this.context_.getKeys();
        }

        public Object remove(Object key) {
            if (this.context_.get(key.toString()) instanceof ConstantValue) {
                this.runtimeServices_.getLog().debug((Object)("cannot remove constant value: " + key));
                return null;
            }
            return this.context_.remove(key);
        }
    }
}

