/*
 * Decompiled with CFR 0.152.
 */
package jp.techlier.extra.velocity.directive;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import jp.techlier.extra.velocity.directive.DirectiveUtils;
import jp.techlier.extra.velocity.directive.Nil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class Block
extends Directive {
    public static final String LATE_RENDERING = "directive.block.late.rendering";
    private static final boolean DEFAULT_LATE_RENDERING = false;

    public String getName() {
        return "block";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        DirectiveUtils util = new DirectiveUtils(this, this.rsvc, context, node);
        if (node.jjtGetNumChildren() != 2) {
            return util.error("invalid argument count");
        }
        String blockName = util.getStringArgument(0);
        if (blockName == null) {
            return false;
        }
        HashMap<String, Object> blockRefs = (HashMap<String, Object>)context.get(Block.class.getName());
        if (blockRefs == null) {
            blockRefs = new HashMap<String, Object>();
            context.put(Block.class.getName(), blockRefs);
        }
        if (writer instanceof Nil.NilWriter) {
            if (!blockRefs.containsKey(blockName)) {
                boolean renderingLater = this.rsvc.getBoolean(LATE_RENDERING, false);
                if (renderingLater) {
                    blockRefs.put(blockName, node.jjtGetChild(1));
                } else {
                    StringWriter blockWriter = new StringWriter();
                    if (!node.jjtGetChild(1).render(context, (Writer)blockWriter)) {
                        return false;
                    }
                    blockRefs.put(blockName, blockWriter.toString());
                }
            }
        } else if (blockRefs.containsKey(blockName)) {
            Object blockObject = blockRefs.get(blockName);
            if (blockObject instanceof Node) {
                ((Node)blockObject).render(context, writer);
            } else {
                writer.write(blockObject.toString());
            }
        } else {
            return node.jjtGetChild(1).render(context, writer);
        }
        return true;
    }
}

