/*
 * Decompiled with CFR 0.152.
 */
package jp.techlier.commons.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jp.techlier.commons.lang.reflect.ReflectUtilsException;

public class ReflectUtils {
    private ReflectUtils() {
        assert (false) : "utility class cannot instanciate.";
    }

    public static Object get(Object obj, String filedName) throws ReflectUtilsException {
        return ReflectUtils.get(obj.getClass(), obj, filedName);
    }

    public static Object get(Class<?> clazz, String name) throws ReflectUtilsException {
        return ReflectUtils.get(clazz, null, name);
    }

    public static Object get(Class<?> clazz, final Object obj, String name) throws ReflectUtilsException {
        Field field;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            throw new ReflectUtilsException("No such field: " + clazz.getName() + "#" + name, ex);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean previousAccessibility = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object object = field.get(obj);
                    return object;
                }
                catch (Exception ex) {
                    throw new ReflectUtilsException(field.toString(), ex);
                }
                finally {
                    field.setAccessible(previousAccessibility);
                }
            }
        });
    }

    public static void set(Object obj, String name, Object value) throws ReflectUtilsException {
        ReflectUtils.set(obj.getClass(), obj, name, value);
    }

    public static void set(Class<?> clazz, String name, Object value) throws ReflectUtilsException {
        ReflectUtils.set(clazz, null, name, value);
    }

    public static void set(Class<?> clazz, final Object obj, String name, final Object value) throws ReflectUtilsException {
        Field field;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            throw new ReflectUtilsException("No such field: " + clazz.getName() + "." + name, ex);
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                boolean previousAccessibility = field.isAccessible();
                try {
                    field.setAccessible(true);
                    field.set(obj, value);
                    return null;
                }
                catch (Exception ex) {
                    throw new ReflectUtilsException(field.toString(), ex);
                }
                finally {
                    field.setAccessible(previousAccessibility);
                }
            }
        });
    }

    public static Object invoke(Object obj, String name) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(obj.getClass(), obj, name, null, null);
    }

    public static Object invoke(Object obj, String name, Object ... args) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(obj.getClass(), obj, name, null, args);
    }

    public static Object invoke(Object obj, String name, Class<?>[] parameterTypes, Object ... args) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(obj.getClass(), obj, name, parameterTypes, args);
    }

    public static Object invoke(Class<?> clazz, String name) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(clazz, null, name, null, null);
    }

    public static Object invoke(Class<?> clazz, String name, Object ... args) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(clazz, null, name, null, args);
    }

    public static Object invoke(Class<?> clazz, String name, Class<?>[] parameterTypes, Object ... args) throws ReflectUtilsException, Throwable {
        return ReflectUtils.invoke(clazz, null, name, parameterTypes, args);
    }

    public static Object invoke(Class<?> clazz, final Object obj, String name, Class<?>[] parameterTypes, final Object ... args) throws ReflectUtilsException, Throwable {
        Method method;
        if (parameterTypes == null && args != null) {
            parameterTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                parameterTypes[i] = args[i].getClass();
                ++i;
            }
        }
        try {
            method = clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ReflectUtilsException("No such method: " + ex.getMessage(), ex);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    boolean previousAccessibility = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        Object object = method.invoke(obj, args);
                        return object;
                    }
                    catch (Exception ex) {
                        throw new ReflectUtilsException(method.toString(), ex);
                    }
                    finally {
                        method.setAccessible(previousAccessibility);
                    }
                }
            });
        }
        catch (ReflectUtilsException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationTargetException) {
                throw cause.getCause();
            }
            throw ex;
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectUtilsException, Throwable {
        return ReflectUtils.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) throws ReflectUtilsException, Throwable {
        return ReflectUtils.newInstance(clazz, null, args);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] parameterTypes, final Object ... args) throws ReflectUtilsException, Throwable {
        Constructor<T> constructor;
        if (parameterTypes == null && args != null) {
            parameterTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                parameterTypes[i] = args[i].getClass();
                ++i;
            }
        }
        try {
            constructor = clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ReflectUtilsException("No such constructor: " + ex.getMessage(), ex);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    boolean previousAccessibility = constructor.isAccessible();
                    try {
                        constructor.setAccessible(true);
                        Object t = constructor.newInstance(args);
                        return t;
                    }
                    catch (Exception ex) {
                        throw new ReflectUtilsException(constructor.toString(), ex);
                    }
                    finally {
                        constructor.setAccessible(previousAccessibility);
                    }
                }
            });
        }
        catch (ReflectUtilsException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationTargetException) {
                throw cause.getCause();
            }
            throw ex;
        }
    }
}

