import configparser, os, codecs
from pyfasttext import FastText #windows時はコメントアウト
import numpy as np
from word_count_window import count
from operator import itemgetter


def chara_analysis_near(project, wordA, wordB):

    content_check = 0
    min_word = 1
    all_words = count(project, content_check, min_word).word_list
    #print(all_words)
    candidate_word=[]
    for i,n in enumerate(all_words):
        if i > 200:
            #print("V",n)
            pass
        else:
            can_word=n[0]
            if can_word == wordA or can_word == wordB:
                pass
            else:
                candidate_word.append(can_word)
    #print(candidate_word)
    return candidate_word

def chara_analysis_minus(project, wordA):

    content_check = 0
    min_word = 1
    all_words = count(project, content_check, min_word).word_list

    candidate_word=[]
    for i,n in enumerate(all_words):
        if i > 200:
            pass
        else:
            can_word=n[0]
            if can_word == wordA:
                pass
            else:
                candidate_word.append(can_word)

    return candidate_word


def near_similar(project, wordA, wordB, model):

#    model, candidate_word = chara_analysis_near(project, wordA, wordB)  #wordAが探索語　wordBが近似化語
    candidate_word = chara_analysis_near(project, wordA, wordB)
    #print(candidate_word)
    ress=[]
    a=model.get_numpy_vector(wordA)
    v2a=model.get_numpy_vector(wordB)

    zero_vector_a = np.zeros(a.shape[0])
    if np.allclose(a, zero_vector_a) == True or np.allclose(v2a, zero_vector_a):
        return "nothing"
    else:
        try:
            while len(candidate_word) > 1:
                for n in candidate_word:
                    candidate_word.remove(n)
                    #print("A",n)
                    for m in candidate_word:

                        b=model.get_numpy_vector(n)
                        c=model.get_numpy_vector(m)

                        formulas = [(a+b+c,"A"), (a+b-c,"B"), (a-b+c,"C"), (a-b-c,"D")]

                        for v1a, co in formulas:
                            cos=np.dot(v2a,v1a) / (np.linalg.norm(v2a) * np.linalg.norm(v1a))
                            if co == "A":
                                co = str(wordA + " + " + n + " + " + m)
                            elif co == "B":
                                co = str(wordA + " + " + n + " - " + m)
                            elif co == "C":
                                co = str(wordA + " - " + n + " + " + m)
                            elif co == "D":
                                co = str(wordA + " - " + n + " - " + m)
                            else:
                                pass
                            ress.append((cos,co))

            aaa= sorted(ress, key=itemgetter(0), reverse=True)
            aaa = aaa[0:59]
            #print(aaa)
            return aaa

        except:
            return "nothing"

def minus(project, wordA, wordB):

    model, candidate_word = chara_analysis_minus(project, wordA, wordB)

    ress=[]
    a=model.get_numpy_vector(wordA)
    v1a=model.get_numpy_vector(wordA)

    zero_vector_a = np.zeros(a.shape[0])
    if np.allclose(a, zero_vector_a) == True:
        return "nothing"
    else:
        while len(candidate_word) > 1:
            for n in candidate_word:
                candidate_word.remove(n)

                b=model.get_numpy_vector(n)

                v2a = a-b
                cos=np.dot(v2a,v1a) / (np.linalg.norm(v2a) * np.linalg.norm(v1a))
                ress.append((n,cos,wordA))

        aaa= sorted(ress, key=itemgetter(1))#, reverse=True)
        aaa = aaa[0:59]


        #print(aaa)
        return aaa



def minus_minus(project, wordA, model):

    #model, candidate_word = chara_analysis_minus(project, wordA)
    candidate_word = chara_analysis_minus(project, wordA)
    ress=[]
    a=model.get_numpy_vector(wordA)
    v1a=model.get_numpy_vector(wordA)

    zero_vector_a = np.zeros(a.shape[0])
    if np.allclose(a, zero_vector_a) == True:
        return "nothing"
    else:
        while len(candidate_word) > 1:
            for n in candidate_word:
                candidate_word.remove(n)

                b=model.get_numpy_vector(n)

                v2a = a-b
                cos=np.dot(v2a,v1a) / (np.linalg.norm(v2a) * np.linalg.norm(v1a))
                ress.append((cos, n,wordA))

                for m in candidate_word:

                    c=model.get_numpy_vector(m)

                    v3a = a-b-c
                    cos=np.dot(v3a,v1a) / (np.linalg.norm(v3a) * np.linalg.norm(v1a))
                    used_word = (n,m)
                    ress.append((cos, used_word, wordA))

        aaa= sorted(ress, key=itemgetter(0))#, reverse=True) #)と#を消した##
        aaa=aaa[0:59]

    #    print(aaa)
        return aaa


    ############################################################
    ################計算式
    #result = model.similarity(wordA,wordB)
    #print("類似度: " + wordA,wordB,result)

    #a=model.get_numpy_vector("アトラクション")
    #b=model.get_numpy_vector("充実")
    #c=model.get_numpy_vector("子ども")
    #print(a+b-c)
    #v2a=a+b-c

    #v1a=model.get_numpy_vector(wordA)
    #v2a=model.get_numpy_vector(wordB)
    #cos=np.dot(v2a,v1a) / (np.linalg.norm(v2a) * np.linalg.norm(v1a))
    #print(cos)



    ############################################################



if __name__=="__main__":
    project = "theme_park"
    wordA ="ディズニーシー"
    #wordB = "ttp"
    #wordA ="USJ"
    wordB = "ディズニーランド"
    #chara_analysis(project, wordA, wordB)
    #minus_minus(project, wordA)
    #minus(project, wordA, wordB)
    path = os.getcwd() + "/fastText/" + project + ".bin"
    model = FastText(path)
    near_similar(project, wordA, wordB, model)
