import sys, configparser, time, MySQLdb, codecs, os
from collections import Counter
from operator import itemgetter

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox, QTreeView,QAbstractItemView,)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, QAbstractItemModel,QModelIndex)

from main_config import main_Config

class MyModel(QAbstractItemModel):
    headers = '語', '出現数'
    items = []

    def __init__(self, parent=None):
        super().__init__()

    def index(self, row, column, parent=QModelIndex()):
        return self.createIndex(row, column, None)

    def parent(self, child):
        return QModelIndex()

    def rowCount(self, parent=QModelIndex()):
        return len(self.items)

    def columnCount(self, parent=QModelIndex()):
        return len(self.headers)

    def data(self, index, role=Qt.DisplayRole):
        if role == Qt.DisplayRole:
            try:
                return self.items[index.row()][index.column()]
            except:
                return
        return

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if role != Qt.DisplayRole:
            return
        if orientation == Qt.Horizontal:
            return self.headers[section]

    def addRow(self, labe, count):
        self.beginInsertRows(QModelIndex(), len(self.items), 1)
        self.items.append([labe, count])
        self.endInsertRows()

    def deleRow(self):
        self.items.clear()

class View(QTreeView):
    def __init__(self, parent=None):
        super(View, self).__init__(parent)
        self.setItemsExpandable(False)
        self.setIndentation(0)
        self.setSelectionMode(QAbstractItemView.ExtendedSelection)

    def drawBranches(self, painter, rect, index):
        return

class Word_Count(QDialog):
    def __init__(self, parent, project, content_check, min_word):
        QDialog.__init__(self, parent)
        self.setModal(0)

        g = codecs.open("window_temp.txt","w", "utf-8")
        g.write("1")
        g.close()

        self.word_list=count(project, content_check, min_word).word_list
        #print(type(self.word_list))
        self.word_count_window()

    def word_count_window(self):
        #self.setWindowFlags(Qt.WindowCloseButtonHint)

        search_hbox=QHBoxLayout()
        self.search_word=QLineEdit()
        search_button=QPushButton("検索")
        search_button.clicked.connect(self.search)
        search_hbox.addWidget(self.search_word)
        search_hbox.addWidget(search_button)

        self.model=MyModel(self)
        self.view=View()
        self.view.setModel(self.model)
        self.view.setUniformRowHeights(True)
        self.view.setColumnWidth(0, 200)

        hbox=QHBoxLayout()
        close_button = QPushButton("閉じる", self)
        close_button.setFocusPolicy(Qt.NoFocus)
        close_button.clicked.connect(self.exit)
        hbox.addStretch(1)
        hbox.addWidget(close_button)


        main_v_layout=QVBoxLayout()
        main_v_layout.addLayout(search_hbox)
        main_v_layout.addWidget(self.view)
        #main_v_layout.addStretch(1)
        main_v_layout.addLayout(hbox)

        self.setWindowTitle("出現語")
        self.setGeometry(900, 300, 350, 400)
        self.setLayout(main_v_layout)

        self.insert_tree()

        self.activateWindow()

        self.show()

    def search(self):

        self.searched_list=[]
        for n in self.word_list:
            if self.search_word.text() == "":
                self.searched_list=self.word_list
            elif self.search_word.text() in n[0]:
                self.searched_list.append(n)
            else:
                pass
        #print(searched_list)
        self.model.deleRow()

        for n in self.searched_list:
            label=n[0]
            count=n[1]
            self.model.addRow(label,count)


    def insert_tree(self):
        for n in self.word_list:
            label=n[0]
            count=n[1]
            self.model.addRow(label,count)

    def closeEvent(self, event):
        self.model.items.clear()
        g = codecs.open("window_temp.txt","w","utf-8")
        g.write("0")
        g.close()


    def exit(self):
        self.close()
        g = codecs.open("window_temp.txt","w", "utf-8")
        g.write("0")
        g.close()
        #print(self.aa)
        #self.done()

class count():
    def __init__(self, project, content_check, min_word):
        self.count(project, content_check, min_word)

    def count(self, project, content_check, min_word):

#        config=configparser.ConfigParser()
#        config.read('main.ini')
#        mysql_id=config['settings']["id"]
#        mysql_pass=config['settings']["pass"]
        mysql_id, mysql_pass, projects, root_path, using_os = main_Config()

        cfg=configparser.ConfigParser()
        file_path = project + ".ini"
        cfg.read(file_path)
        sampling=cfg['project']["sample"]

        sql = self.import_morpheme(project, sampling, content_check)
        time.sleep(0.1)
        res = self.import_from_mysql(project, mysql_id, mysql_pass, sql)
        #print(res)
        time.sleep(0.1)
        res = self.list_set(res)
        time.sleep(0.1)
        self.word_list = self.count_word(res, min_word, project)
        time.sleep(0.1)

    def count_word(self, words, min_word, project):
        counter = Counter(words)
        word_list = []
        for word, cnt in counter.most_common():
            if cnt >= int(min_word):
                counted = (word, cnt)
                word_list.append(counted)
            else:
                pass

        word_listB = self.vec_list_count(word_list, project)
        return word_listB

    def vec_list_count(self,word_list, project):    #vecファイルにない単語を消す
        word_list = dict(word_list) #タプルリストを辞書型に変換
        word_keys = word_list.keys()
        #print(word_keys)

        path = os.getcwd() + "/fastText/" + project + ".vec"
        f = codecs.open(path, 'r', 'utf-8')
        reader=f.readlines()
        f.close()
        vec_word = []
        for n in reader:
            #word = n[1]
            #print(n)
            n = n.split(" ")
            #print(n[0])
            if n[0] == "</s>":
                pass
            else:
                vec_word.append(n[0])

        re_list = set(word_keys) - set(vec_word)
        #print(re_list)

        for n in re_list:
            del word_list[n]



        word_list = word_list.items()   #辞書型からタプルリストに変換
        word_list = sorted(word_list, key=lambda x:x[1], reverse=True)
        return word_list


    def list_set(self, res):
        words=[]
        for word in res:
            word=str(word)
            word=word.replace("('","").replace("',)","")
            word=word.split(" ")
            wordb=[]
            for worda in word:
                if worda == "":
                    pass
                else:
                    wordb.append(worda)
            wordb=list(set(wordb))  #setにすることで文書数で単語をカウントする
            ####################################################
            #ここでsetしなければ、文書数ではなく、総出現数もカウントできる
            ####################################################
            words.extend(wordb)
        return words

    def import_from_mysql(self, project, mysql_id, mysql_pass, sql):
        try:
            conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
            cursor=conn.cursor()

            cursor.execute(sql)
            time.sleep(0.2)

            words=list(cursor.fetchall())

            conn.commit()
            cursor.close()
            conn.close()

            return words

        except Exception as e:
            print(e)

    def import_morpheme(self, project, sampling, content_check):
        if int(sampling) == 1:
            if content_check == 0:  #サンプリングあり、内容語
                sql = "select content_word from text_table where sampling = 1"
            else:   #サンプリングあり、全単語
                sql = "select morpheme from text_table where sampling = 1"
        elif int(sampling) == 0:
            if content_check == 0:  #サンプリングなし、内容語
                sql = "select content_word from text_table"
            else:   #サンプリングなし、全単語
                sql = "select morpheme from text_table"
        elif int(sampling) == 10 or int(sampling) == 11:
            if content_check == 0:
                sql = "select content_word from text_table where train_test_data = 1"
            else:
                sql = "select morpheme from text_table where train_test_data = 1"
        return sql




if __name__=="__main__":
    app=QApplication(sys.argv)
    project="kakko"
    min_check=1
    con=0
    parent=QDialog()
    Word_Count(parent, project, con, min_check)
    sys.exit(app.exec_())
