#######################################
#新しいモデルの作成ウィンドウ
#######################################
import sys, codecs, configparser, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox, QTreeView,QAbstractItemView)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel,)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, QAbstractItemModel,QModelIndex)
#from PyQt5 import QtGui

from regist_file import regist_File
from write_project_ini import write_pro_ini
from mysql_create_database import main_create_database
from mysql_reserved_word import reserved_word_check


class MyModel(QAbstractItemModel):

    headers = 'カテゴリー', 'ラベル', 'ファイル名'
    items = []

    def __init__(self, parent=None):
        super(MyModel, self).__init__(parent)


    def index(self, row, column, parent=QModelIndex()):
        return self.createIndex(row, column, None)

    def parent(self, child):
        return QModelIndex()

    def rowCount(self, parent=QModelIndex()):
        return len(self.items)

    def columnCount(self, parent=QModelIndex()):
        return len(self.headers)

    def data(self, index, role=Qt.DisplayRole):
        if role == Qt.DisplayRole:
            try:
                return self.items[index.row()][index.column()]
            except:
                return
        return

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if role != Qt.DisplayRole:
            return
        if orientation == Qt.Horizontal:
            return self.headers[section]

    def addRow(self, cate, labe, fi):
        self.beginInsertRows(QModelIndex(), len(self.items), 1)
        self.items.insert(0,(cate, labe, fi))
        self.endInsertRows()

    def removeRows(self, rowIndexes):
        for row in sorted(rowIndexes, reverse=True):
            self.beginRemoveRows(QModelIndex(), row, row + 1)
            #print(self.items[row])
            del self.items[row]
            self.endRemoveRows()

    def all_print(self):
        #print(self.items)
        return self.items

class View(QTreeView):
    def __init__(self, parent=None):
        super(View, self).__init__(parent)
        self.setItemsExpandable(False)
        self.setIndentation(0)
        self.setSelectionMode(QAbstractItemView.ExtendedSelection)

    def drawBranches(self, painter, rect, index):
        return

class new_project_SubWindow(QWidget,QAbstractItemModel):

    def __init__(self, p):
        super().__init__()

        self.p=p

        MyModel.items=[]

        self.open_project()

    def open_project(self):
        self.w=QDialog()
        label = QLabel()
        label.setText('新規プロジェクトの登録')

        hbox=QHBoxLayout()
        label_project_name=QLabel()
        label_project_name.setText('プロジェクト名')
        self.new_project_name=QLineEdit()

        hbox.addWidget(label_project_name)
        hbox.addWidget(self.new_project_name)

        hbox2=QHBoxLayout()
        to_regist_button=QPushButton("学習用ファイルを追加")
        to_regist_button.clicked.connect(self.addItem)
        hbox2.addWidget(to_regist_button)
        hbox2.addStretch(1)

        #hbox2.addStretch(1)

#############################################################
        self.model=MyModel(self)
        self.view=View()
        self.view.setModel(self.model)
        self.view.setUniformRowHeights(True)
#############################################################

        hbox4=QHBoxLayout()
        hbox4.addStretch(1)
        delete_file_button=QPushButton("学習用ファイルを削除")
        delete_file_button.clicked.connect(self.removeItems)
        hbox4.addWidget(delete_file_button)
        correction_file_button=QPushButton("学習用ファイルを修正")
        correction_file_button.clicked.connect(self.correct_item)
        hbox4.addWidget(correction_file_button)


        hbox3=QHBoxLayout()
        to_cancel=QPushButton("キャンセル")
        to_cancel.clicked.connect(self.w.close)
        to_return=QPushButton("登録する")
        to_return.clicked.connect(self.return_to_main)
        hbox3.addStretch(1)
        hbox3.addWidget(to_return)
        hbox3.addWidget(to_cancel)

        layout=QVBoxLayout()
        layout.addWidget(label)
        layout.addLayout(hbox)
        layout.addStretch(1)
        layout.addLayout(hbox2)
        layout.addWidget(self.view)
        layout.addLayout(hbox4)
        layout.addStretch(1)
        layout.addLayout(hbox3)

        self.w.setLayout(layout)

        self.w.setGeometry(650, 300, 400, 400)

        self.w.setWindowTitle("新規プロジェクトの作成")


#############################################################
    def correct_item(self):
        rows=[]
        for index in self.view.selectedIndexes():
            if index.column() == 0:
                rows.append(index.row())

        if len(rows)>1:
            #print("1行ずつ修正してください")
            message=QMessageBox.information(self,"お知らせ",  "1行ずつ修正してください", QMessageBox.Ok)
        elif len(rows)==0:
            #print("修正したいファイルを選択してください")
            message=QMessageBox.information(self,"お知らせ",  "修正したいファイルを選択してください", QMessageBox.Ok)
        else:
            #print(rows[0])
            ro=rows[0]
            #print(MyModel().items)
            for_correct=MyModel().items[ro]
            cateA=for_correct[0]
            labeA=for_correct[1]
            fileA=for_correct[2]

            self.model.removeRows(rows)

            registed_list=self.model.all_print()
            categ=[]
            labeln=[]
            file_n=[]
            for n in registed_list:
                cate=n[0]
                categ.append(cate)
                labe=n[1]
                labeln.append(labe)
                fil_=n[2]
                file_n.append(fil_)
            #print(cate, labe, fil_)
            subwindow=regist_File(categ,labeln,file_n,cateA,labeA, fileA)

            subwindow.show()

            if os.path.exists("./cala_temp.txt") == True:

                g = codecs.open("cala_temp.txt","r","utf-8")
                cala=g.readline()
                if cala=="":
                    category=cateA
                    label=labeA
                    file_name=fileA
                    self.model.addRow(category,label,file_name)
                else:
                    kara=cala.split(",")
                    category=kara[0]
                    label=kara[1]
                    filepath=kara[2]
                    file_name=filepath.split("/")
                    file_name=file_name[-1]

                    g.close()

                    g = codecs.open("cala_temp.txt","w","utf-8")
                    g.write("")
                    g.close()

                    self.model.addRow(category,label,filepath)

            else:
                pass

#############################################################
    def addItem(self):
        result=self.make_regist_project()
        if result==None:
            #print("errorだってよ")
            pass
        else:
            #print(type(result))
            ca=result[0]
            la=result[1]
            fi=result[2]

            self.model.addRow(ca,la,fi)

    def selectedRows(self):
        rows = []
        for index in self.view.selectedIndexes():
            if index.column() == 0:
                rows.append(index.row())
        return rows

    def removeItems(self):
        self.model.removeRows(self.selectedRows())




#############################################################
#メイン画面に戻るボタン
#############################################################
    def return_to_main(self):
        re=self.model.all_print()

        ch=0
        for n in self.p:
            if n == self.new_project_name.text():
                ch += 1
            else:
                pass

        ch2=reserved_word_check(self.new_project_name.text())  #プロジェクト名が予約語ではないかをチェックし、予約語であれば1を返す
    #############################################################
    #カテゴリー数とラベル数の不一致を確認
        count_category=[]#カテゴリー
        count_label=[]#ラベル
        count_file=[]
        for r in re:
            if r[0]=="":
                pass
            else:
                count_category.append(r[0])
            if r[1]=="":
                pass
            else:
                count_label.append(r[1])
            count_file.append(r[2])

        if len(count_category)>0 and len(count_category) != len(count_file):
            message=QMessageBox.information(self,"お知らせ",  "カテゴリー名が未登録のファイルがあります", QMessageBox.Ok)
            #print("カテゴリー名が未登録のファイルがあります")
        elif len(count_label)>0 and len(count_label) != len(count_file):
            message=QMessageBox.information(self,"お知らせ",  "ラベル名が未登録のファイルがあります", QMessageBox.Ok)
            #print("ラベル名が未登録のファイルがあります")
    #############################################################
        else:
            project_name=self.new_project_name.text()

            if project_name=="":
                message=QMessageBox.information(self,"お知らせ",  "プロジェクト名を入力してください", QMessageBox.Ok)
                #print("プロジェクト名を入力してください")
            elif ch2 > 0:
                message=QMessageBox.information(self,"お知らせ",  "その単語は予約語のため使用できません", QMessageBox.Ok)
                #print("その単語は予約語のため使用できません")
            elif ch > 0:
                message=QMessageBox.information(self,"お知らせ",  "同名のプロジェクトが存在します", QMessageBox.Ok)
                #print("同名のプロジェクトが存在します")
            else:
                if len(re)==0:
                    message=QMessageBox.information(self,"お知らせ",  "ファイルが選択されていません", QMessageBox.Ok)
                    #print("ファイルが選択されていません")
                else:
                    g = codecs.open("select_project_temp.txt","w", "utf-8")
                    g.write(project_name)
                    g.close()

        ##############################################################
        #プロジェクトにiniファイルを登録
        ##############################################################
                    files=str(self.model.all_print())
                    files=files.replace("[","").replace("]","")

                    write_pro_ini(project_name).main(
                    files=files,
                    original_data_type="2",
                    )   #iniファイルにプロジェクトを登録

        ##############################################################
        #プロジェクトデータベースを作成
        ##############################################################

                    main_create_database(project_name)

                    self.w.close()

    def make_regist_project(self):
        registed_list=self.model.all_print()
        categ=[]
        labeln=[]
        file_n=[]
        for n in registed_list:
            cate=n[0]
            categ.append(cate)
            labe=n[1]
            labeln.append(labe)
            fil_=n[2]
            file_n.append(fil_)

        subwindow=regist_File(categ,labeln,file_n)  #from regist_file
        subwindow.show()
        #print(G_category,G_label)

####################################################
#        g = codecs.open("cala_temp.txt","r", "utf-8")
#        cala=g.readline()
        #print(cala)
#        g.close()
####################################################

        #print(os.path.exists("cala_temp.txt"))

        #if os.path.exists("./cara_temp.txt") == True:
        if os.path.exists("cala_temp.txt") == True: #for mac
            #print("B")
            g = codecs.open("cala_temp.txt","r", "utf-8")
            cala=g.readline()
            if cala=="":
                pass
            else:
                kara=cala.split(",")
                category=kara[0]
                label=kara[1]
                file_path=kara[2]

                file_name=file_path.split("/")
                file_name=file_name[-1]
                #print(kara)
                g.close()

                g = codecs.open("cala_temp.txt","w","utf-8")
                g.write("")
                g.close()

                return category,label,file_path

        else:
            #print("C")
            pass

    def show(self):
        self.w.exec_()


if __name__=="__main__":
    app=QApplication(sys.argv)

    p=["a","b"]

    ex=new_project_SubWindow(p)
    new_project_SubWindow(p).show()
    sys.exit(app.exec_())
