import MySQLdb      #mysqlを使うモジュール
import time         #sleep用
import configparser #iniファイルの読み込み
from PyQt5.QtWidgets import QMessageBox
import codecs, inspect

from main_config import main_Config

def main_create_database(project_name):
    #config=configparser.ConfigParser()
    #config.read("ok_main.ini")
    #mysql_id=config["ok_settings"]["id"]
    #mysql_pass=config["ok_settings"]["pass"]

    mysql_id, mysql_pass, projects, root_path, using_os = main_Config()

    check = database_check(project_name,mysql_id,mysql_pass)
    time.sleep(0.31)

    if check > 0:
        #print("かぶってるよ")
        return 0
    else:
        create_database(project_name,mysql_id,mysql_pass)
        time.sleep(0.1)
        create_table(project_name,mysql_id,mysql_pass)
        time.sleep(0.1)
        return 1

def database_check(project_name, mysql_id, mysql_pass):
    try:
        conn=MySQLdb.connect(user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        sql="show databases"
        cursor.execute(sql)
        databases=list(cursor.fetchall())

        conn.commit()
        cursor.close()
        conn.close()

        check=0
        for database in databases:
            database=database[0]
            if database == project_name:
                check += 1
            else:
                check += 0

        return check

    except Exception as e:
        print(e)

def create_database(project_name,mysql_id,mysql_pass):
    try:
        conn=MySQLdb.connect(user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        sql="create database "+ project_name + " character set utf8mb4"
        cursor.execute(sql)

        conn.commit()
        cursor.close()
        conn.close()

    except Exception as e:
        print(e)

def create_table(project_name,mysql_id,mysql_pass):
    try:
        conn=MySQLdb.connect(db=project_name, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        sql="create table text_table(sentence_id mediumint unsigned auto_increment primary key, category_name text, \
        label_name text, original_sentence text, morpheme text, part_of_speech text, content_word text, \
        disc_code tinyint, sentence_vector text, sampling tinyint, train_test_data tinyint, \
        k_means_label tinyint, filtering_no tinyint default 0, correlation tinyint)"
        #sentence_id=テキストのID番号
        #original_sentence=元のテキスト
        #morpheme=形態素解析済みのテキスト
        #part_of_speech=品詞
        #content_word text=内容語だけのカラム
        #disc_code=再ラベリングの結果
        #sentence_vector=テキストのベクトル表現
        #sampling=テキストをサンプリングして使用する場合にチェック
        #train_test_data=教師データと検証用データの区分
        #k_means_label=k_meansほうで分類を行った結果を保存
        #correlation=相関分析時のクラスターラベル
        cursor.execute(sql)

        conn.commit()
        cursor.close()
        conn.close()

        #print("テーブル作成OK")

    except Exception as e:
        print(e)



if __name__=="__main__":
    main_create_database("iro")
