############################################################
#
#分析→類似度計算
#
############################################################
import configparser, os, codecs
from pyfasttext import FastText #windows版ではコメントアウト
import numpy as np
#import warnings
#warnings.filterwarnings(action='ignore', category=UserWarning, module='gensim')
#import gensim

#from gensim.models import FastText
#from gensim.test.utils import datapath
import numpy.core._methods
import numpy.lib.format
import scipy.spatial.ckdtree

from word_count_window import count

class Similarity_Calcuration():
    def __init__(self, project, wordA, wordB):
        #self.result = wordA + wordB
        self.project=project
        self.wordA=wordA
        self.wordB=wordB

############################################################
################windows gensim用
#        path = os.getcwd() + "/fasttext/" + project + ".vec"
#        model = gensim.models.KeyedVectors.load_word2vec_format(path, binary=False)

#        v1a=model[self.wordA]
#        v1a=np.asarray(v1a)
#        v2a=model[wordB]
#        v2a=np.asarray(v2a)
#        vss=v1a+v2a
#        self.result=np.dot(v1a,v2a) / (np.linalg.norm(v1a) * np.linalg.norm(v2a))
#        print(self.result)

############################################################
################windows:my calcuration
        if os.name == "nt":
            path = os.getcwd() + "/fastText/" + self.project + ".vec"
            f = codecs.open(path, 'r', 'utf-8')
            reader=f.readlines()
            f.close()

            content_check = 0
            min_word = 1
            all_words = count(self.project, content_check, min_word).word_list

            cfg=configparser.ConfigParser()
            file_path = self.selected_project + ".ini"
            cfg.read(file_path)
            dimensions=int(cfg['project']["dimensions"])

            all_word=[]
            for n in all_words:
                all_word.append(n[0])

            if (wordA in all_word) == False:
                self.result = "nothing"
            elif (wordB in all_word) == False:
                self.result = "nothing"
            else:
                word_array = {}
                for i, n in enumerate(reader):
                    if i == 0:
                        pass
                    else:
                        n = n.split(" ")
                        vec=n[1:dimensions + 1]

                        vector=[]
                        label=n[0]
                        for j in vec:
                            j=float(j)
                            vector.append(j)

                        vector=tuple(vector)
                        vector=np.asarray(vector)
                        a={label:vector}
                        word_array.update(a)

                v1a=word_array[self.wordA]
                v2a=word_array[self.wordB]

                self.result=(np.dot(v1a,v2a) / (np.linalg.norm(v1a) * np.linalg.norm(v2a)))
                self.result=round(self.result,5)

        else:
            #pass   #windows版で使用
############################################################
################pyfasttext用
            path = os.getcwd() + "/fastText/" + project + ".bin"
            model = FastText(path)

            self.result = model.similarity(wordA, wordB)
            #print(type(self.result))
############################################################

if __name__=="__main__":
    project="catelabetest"
    wordA="子供連れ"
    wordB="パンダ"
    Similarity_Calcuration(project, wordA, wordB)
