import sys, configparser, os, time, subprocess, codecs

from encode_to_utf8 import main_code
from tyo_on import tyo_on_encode
from delete_symbol import delete_symbols
from zenkaku_hankaku import zen_han
#from pyfasttext import FastText
from main_config import main_Config

def divide_Class(project, file_path):

#    config=configparser.ConfigParser()
#    config.read('main.ini')
#    using_os=config['settings']["os"]
    mysql_id, mysql_pass, projects, root_path, using_os = main_Config()

    cfg = configparser.ConfigParser()
    ini_path = project + ".ini"
    cfg.read(ini_path)
    tyo_on=cfg['project']["tyo_on"]
    han=cfg['project']["han"]
    zen=cfg['project']["zen"]
    zenkaku_hankaku=cfg['project']["zen_han"]
    basis_word=cfg['project']["basis_word"]

    path = os.getcwd()

    main_code(file_path)    # from encode_to_utf8
    time.sleep(0.1)

    if tyo_on == "1":
        tyo_on_encode() # from tyo_on
    else:
        pass

    if han == "0":
        pass
    else:
        delete_symbols(han,zen)

    if zenkaku_hankaku == "1":
        zen_han()
    else:
        pass

    morpheme(basis_word, path, using_os)
    time.sleep(0.1)
    result = evaluate(path, project)

    time.sleep(0.1)
    path=os.getcwd()
    path1=path + "/mor_temp.txt"
    os.remove(path1)
    time.sleep(0.1)
    path2=path + "/encode_temp.txt"
    os.remove(path2)
    time.sleep(0.1)

    return result


def evaluate(path, project):
    path = os.getcwd()
    cmd= path + "/fastText/fastText predict-prob " + path + "/fastText/" + project + ".bin " + path + "/mor_temp.txt"

    proc = subprocess.Popen(cmd, shell = True, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
    stdout_data, stderr_data = proc.communicate() #処理実行を待つ(†1)
    #print(stdout_data)  #標準出力の確認
    #print(stderr_data)  #標準エラーの確認
    proc.wait()

    stdout_data = stdout_data.decode("utf-8")
    stdout_data = stdout_data.split("\n")

    test_data=[]
    for n in stdout_data:
        if n == "":
            pass
        else:
            test_data.append(n)

    test_data_count=len(test_data)

    g = codecs.open("encode_temp.txt","r", "utf-8")
    sentence = g.readlines()

    res=[]
    for (i, j) in zip(sentence,test_data):
        text = i.replace("\n","")
        n = j.split(",")
        label = n[0].replace("__label__","")
        evaluation = n[1]
        a=(label, evaluation, text)
        res.append(a)


#    path = path + "/fasttext/" + project + ".bin"
#    model = FastText(path)

#    res=[]
#    for n in result:
        #print("A", n)
#        if n is not None:
            #print(n)
#            b=model.predict_proba_single(n, k=1)
#            label=(str((b[0])[0])).replace(",","")
#            evaluation=(b[0])[1]
#            text=n

#            a=(label, evaluation, text)
#            res.append(a)
#        else:
#            pass

    return res

def morpheme(basis_word_check, path, using_os):
    g = open("mor_temp.txt","w")
    g.write("")
    g.close()

    if using_os == "nt":
        if basis_word_check == 0:
            cmd = path + '/mecab/bin/mecab.exe ' + path + '/encode_temp.txt -r ' + path + '/mecab/bin/mecabrc -o ' + path + '/mor_temp.txt -F"%f[6] " -U"%m " -E"\\r\\n" '
        else:
            cmd = path + '/mecab/bin/mecab.exe -Owakati ' + path + '/encode_temp.txt -r ' + path + '/mecab/bin/mecabrc -o ' + path + '/mor_temp.txt'
    elif using_os == "posix":
        if basis_word_check == 0:
            cmd='mecab ' + path + '/encode_temp.txt -F"%f[6] " -U"%m " -E"\n" -o ' + path + '/mor_temp.txt'   #基本形
        else:
            cmd='mecab -Owakati ' + path + '/encode_temp.txt -o ' + path + '/mor_temp.txt'   #表層形

    else:
        pass

    popen = subprocess.Popen(cmd, shell=True)
    popen.wait()

    time.sleep(0.2)

    #g = open("mor_temp.txt","r")
    #mor_temp=g.readlines()

    #mor_text=[]
    #for n in mor_temp:
    #    n = n.replace(" \n", "")
    #    mor_text.append(n)

    #return mor_text

if __name__=="__main__":
    project="ttt"
    file_path="C:/Users/darth/Desktop/test/fastText/one peace.txt"
    divide_Class(project, file_path)
