<?php
/* これは文字化け防止のための日本語文字列です。
   このソースファイルは UTF-8 で保存されています。
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with UTF-8. */
/*
Plugin Name: VC Search
Plugin URI: http://review.web-service-api.jp/
Description: 各種APIを利用したアイテム検索、ショッピングモール風アフィリエイト用プラグイン。商品検索をさせるためのリンクを生成し、またその検索結果ページを表示するブログ連携機能など。
Author: wackey
Version: 1.12
Author URI: http://musilog.net/
*/

/*  Copyright 2009 wackey

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ヘッダにプラグイン用CSS追記
function add_vc_css() {
echo "<link rel=\"stylesheet\" href=\"".WP_PLUGIN_URL."/vc_search/vc_search.css\" type=\"text/css\" />";
}


// 検索結果描画
function vcpage_func( $atts, $content = null ) {

// バリュコマなら
if ($_GET["pagetype"]=="vc") {

$vctoken= get_option('vc_search_token');
$vcpagepage= get_option('vc_search_page');
$vc_yahoo_appid= get_option('vc_yahoo_appid');

$arr_sorts = array(
	"0" => "スコア順", 
	"1" => "価格の高い順", 
	"2" => "価格の安い順" ,
	"3" => "今日の売れ筋順", 
	"4" => "週間の売れ筋順" ,
	"5" => "月間の売れ筋順" 
);

$arr_categories = array(
	"computers"         => "コンピュータ", 
	"electronics"       => "家電、AV機器", 
	"music"             => "音楽、CD", 
	"books"             => "本、コミック", 
	"dvd"               => "DVD", 
	"fooddrink"         => "フード、ドリンク", 
	"fashion"           => "ファッション、アクセサリー", 
	"beautys"           => "美容、健康", 
	"toysgameshobbies"  => "おもちゃ、ホビー", 
	"recreationoutdoor" => "レジャー、アウトドア", 
	"homeinterior"      => "生活、インテリア", 
	"babymaternity"     => "ベビー、キッズ、マタニティ", 
	"officesupplies"    => "ビジネス、ステーショナリー"
);

// フォームからGETで送られて受け取った値を変数へ格納

$v_category =$_GET["category"];
$v_keyword =$_GET["keyword"];
$v_page =$_GET["page"];
$v_sort_by =$_GET["sort_by"];
$v_sort_order =$_GET["sort_order"];
$v_sort_type =$_GET["sort_type"];
$v_sort_rank=$_GET["rank"];
$v_jancode=$_GET["jancode"];// JANコードはAPIで対応したら使う

$keyword = $v_keyword; //表示用
$v_keyword = urlencode(str_replace(" ", "+", trim($v_keyword))); //検索する場合は、トリムをかけて空白は「＋」で繋ぐ（AND検索）

// デフォルト値の設定
if(!isset($v_page)) $v_page = "";
if(!isset($v_sort_by)) $v_sort_by = "";
if(!isset($v_sort_order)) $v_sort_order = "";
if(!isset($v_sort_type)) $v_sort_type = 0;
if(!isset($v_page) || $v_page == "") $v_page = 1;
if(!isset($v_sort_rank)) $v_sort_rank = "";
if(!isset($v_jancode)) $v_jancode = "";

// 並べ順の選択肢からパラメータを設定
switch ($v_sort_type) {
case 0:
	$v_sort_by = "score";
	$v_sort_order = "asc";
	break;
case 1: //価格安い順
	$v_sort_by = "price";
	$v_sort_order = "desc";
	break;
case 2: //価格高い順
	$v_sort_by = "price";
	$v_sort_order = "asc";
	break;
case 3: //今日の売れ筋順
	$v_sort_rank = "dayly";
	break;
case 4: //週間の売れ筋順
	$v_sort_rank = "weekly";
	break;
case 5: //月間の売れ筋順
	$v_sort_rank = "monthly";
	break;
default:
	break;
}


// バリューコマースリクエストURL組み立て
$vcurl = "http://webservice.valuecommerce.ne.jp/productdb/search?token=$vctoken&keyword=$v_keyword&category=$v_category&sort_by=$v_sort_by&sort_order=$v_sort_order&page=$v_page&results_per_page=10&rank=$v_sort_rank";

// 改ページ用パラメータ
$params = $vcpagepage . "pagetype=vc&keyword=$v_keyword&category=$v_category&sort_by=$v_sort_by&sort_order=$v_sort_order&sort_type=$v_sort_type&rank=$v_sort_rank";

// バリュコマsimpleXMLデータ取り出し配列変数に代入
$vcBuff = file_get_contents($vcurl);
$vcBuff = str_replace('vc:', 'vc', $vcBuff);
$vcBuff = str_replace('&', '&amp;', $vcBuff);
$xml = simplexml_load_string ($vcBuff);
$hits = $xml->channel->item;

foreach ($hits as $hit) {
$itemname[] = h($hit->title);

$linkurl[] = str_replace('&amp;', '&' ,h($hit->link));

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if (strlen($img[1])) {
	$imgurl[] = h($img[1]);
} else {
	if (strlen($img[2])) {
		$imgurl[] = h($img[2]);
	} else {
	$imgurl[] = WP_PLUGIN_URL."/vc_search/c_img/noimage.gif";
	}
}

$price[] = h($hit->vcprice);
$description[] = h($hit->description);
$shopname[] = h($hit->vcmerchantName) . h($hit->vcsubStoreName);
$vcpvimg[] = $hit->vcpvImg;
$guid[] = h($hit->guid);
$jancode[] = h($hit->vcjanCode);
}
$resultcount = h($xml->channel->vcresultcount);
$totalpage = h($xml->channel->vcpagecount);

// YAHOO!関連検索
$ysmhits = kanren($v_keyword);

// バリュコマならend
} else if ($_GET["pagetype"]=="ls") {
//リンクシェアなら
$lstoken= get_option('ls_search_token');
$vcpagepage= get_option('vc_search_page');
$ls_yahoo_appid= get_option('vc_yahoo_appid');

$arr_sorts = array(
	"0" => "参考価格の安い順", 
	"1" => "参考価格の高い順"
);

// フォームからGETで送られて受け取った値を変数へ格納

$ls_category =$_GET["category"];
$ls_keyword =$_GET["keyword"];
$v_page =$_GET["page"];
$ls_sort_by =$_GET["sort_by"];
$ls_sort_order =$_GET["sort_order"];
$ls_sort_type =$_GET["sort_type"];
$ls_sort_rank=$_GET["rank"];
$ls_jancode=$_GET["jancode"];// JANコードはAPIで対応したら使う

$keyword = $ls_keyword; //表示用
$ls_keyword = urlencode('"'.trim($ls_keyword).'"'); //検索する場合は、トリムをかけて引用符で囲む

// デフォルト値の設定
if(!isset($v_page )) $v_page  = "1";
if(!isset($ls_sort_by)) $ls_sort_by = "";
if(!isset($ls_sort_order)) $ls_sort_order = "";
if(!isset($ls_sort_type)) $ls_sort_type = 0;
if(!isset($v_page ) || $v_page  == "") $v_page  = 1;
if(!isset($ls_sort_rank)) $ls_sort_rank = "";
if(!isset($ls_jancode)) $ls_jancode = "";

// 並べ順の選択肢からパラメータを設定
switch ($ls_sort_type) {
case 0:
	$ls_sort_order = "asc";
	break;
case 1: //価格安い順
	$ls_sort_order = "dsc";
	break;
default:
	break;
}


// リンクシェアリクエストURL組み立て
$lsurl = "http://feed.linksynergy.com/productsearch?token=$lstoken&keyword=$ls_keyword&max=10&pagenumber=$v_page&sort=retailprice&sorttype=$ls_sort_order";

// 改ページ用パラメータ
$params = $vcpagepage . "pagetype=ls&keyword=".urlencode($keyword)."&sort=retailprice&sorttype=$ls_sort_order";

// リンクシェアsimpleXML,データ取り出し配列変数に代入
$lsBuff = file_get_contents($lsurl);

$xml = simplexml_load_string ($lsBuff);
$hits = $xml->item;

foreach ($hits as $hit) {
if (!is_numeric(mb_strpos($hit->merchantname,"携帯"))) {
$itemname[] = h($hit->productname);
$linkurl[] = h($hit->linkurl);
if (strlen($hit->imageurl)) {
	$imgurl[] = h($hit->imageurl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->price);
$description[] = h($hit->description->short);
$shopname[] = h($hit->merchantname);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
if ($hit->merchantname == "イトーヨーカドー　ネット通販") {
	$faviconurl[] = "http://www.itoyokado.jp/";
} else {
	$faviconurl[] = h($hit->imageurl);
}

}

}  //foreach

$resultcount = h($xml->TotalMatches);
$totalpage = h($xml->TotalPages);

// YAHOO!関連検索
$ysmhits = kanren($ls_keyword);

//リンクシェアならend
} else if ($_GET["pagetype"]=="jalan") {
// じゃらんなら

$jalantoken= get_option('jalan_search_token');
$jalan_sid= get_option('jalan_sid');
$jalan_pid= get_option('jalan_pid');
$vcpagepage= get_option('vc_search_page');

// フォームからGETで送られて受け取った値を変数へ格納
$v_page =$_GET["page"];
$jalan_pref =$_GET["pref "];
$jalan_l_area =$_GET["l_area"];
$jalan_s_area =$_GET["s_area"];

// デフォルト値の設定
if(!isset($v_page)) $v_page = "1";


// じゃらんリクエストURL組み立て
$start = 10*($v_page-1)+1;
if ($start< 0) {$start=1;}
$jalanurl = "http://jws.jalan.net/APIAdvance/HotelSearch/V1/?key=$jalantoken&pref=$jalan_pref&l_area=$jalan_l_area&s_area=$jalan_s_area&count=10&start=$start";

// 改ページ用パラメータ
$params = $vcpagepage . "pagetype=jalan&pref=$jalan_pref&l_area=$jalan_l_area&s_area=$jalan_s_area";

//if (isset($jalan_pref)) {
$jalanBuff = @file_get_contents($jalanurl);
$xml = @simplexml_load_string ($jalanBuff);
$hits = $xml->Hotel;
$resultcount = h($xml->NumberOfResults);
$totalpage = h($xml->NumberOfResults) / 10;

if (!$resultcount==0) {
foreach ($hits as $hit) {

$itemname[] = h($hit->HotelName);
$linkurl[] = "http://ck.jp.ap.valuecommerce.com/servlet/referral?sid=$jalan_sid&pid=$jalan_pid&vc_url=".urlencode($hit->HotelDetailURL);
//$linkurl[] = h($hit->HotelDetailURL);
if (strlen($hit->PictureURL)) {
	$imgurl[] = h($hit->PictureURL);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->price);
$description[] = h($hit->HotelCatchCopy).h($hit->HotelCaption);
$shopname[] = h($hit->HotelName);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
$faviconurl[] = h($hit->HotelDetailURL);
$vcpvimg[] = "<img src=\"http://ad.jp.ap.valuecommerce.com/servlet/gifbanner?sid=$jalan_sid&pid=$jalan_pid\" height=\"0\" width=\"0\" border=\"0\">";

}  //foreach
} // if

// じゃらんend
} else if ($_GET["pagetype"]=="rakuten") {
// 楽天市場なら

$rakutentoken= get_option('rakuten_search_token');
$rakutenaffid= get_option('rakuten_affiliate_id');
$vcpagepage= get_option('vc_search_page');
$vc_yahoo_appid= get_option('vc_yahoo_appid');


// フォームからGETで送られて受け取った値を変数へ格納

$rakuten_category =$_GET["category"];
$rakuten_keyword =$_GET["keyword"];
$v_page =$_GET["page"];
$rakuten_sort_by =$_GET["sort_by"];
$rakuten_sort_order =$_GET["sort_order"];
$rakuten_sort_type =$_GET["sort_type"];
$rakuten_sort_rank=$_GET["rank"];
$rakuten_jancode=$_GET["jancode"];
$keyword = urlencode($rakuten_keyword);

// デフォルト値の設定
if(!isset($v_page )) $v_page  = "1";
if(!isset($rakuten_sort_by)) $rakuten_sort_by = "";
if(!isset($rakuten_sort_order)) $rakuten_sort_order = "";
if(!isset($rakuten_sort_type)) $rakuten_sort_type = 0;
if(!isset($v_page ) || $v_page  == "") $v_page  = 1;
if(!isset($rakuten_sort_rank)) $rakuten_sort_rank = "";
if(!isset($rakuten_jancode)) $rakuten_jancode = "";

// 並べ順の選択肢からパラメータを設定
switch ($rakuten_sort_type) {
case 0: //楽天標準ソート順
	$rakuten_sort_order  = "standard";
	break;
case 1: //アフィリエイト料率順（昇順）
	$rakuten_sort_order = "+affiliateRate";
	break;
case 2: //アフィリエイト料率順（降順）
	$rakuten_sort_order  = "-affiliateRate";
	break;
case 3: //レビュー件数順（昇順）
	$rakuten_sort_order  = "+reviewCount";
	break;
case 4: //レビュー件数順（降順）
	$rakuten_sort_order  = "-reviewCount";
	break;
case 5: //価格順（昇順）
	$rakuten_sort_order  = "+itemPrice";
	break;
case 6: //価格順（降順）
	$rakuten_sort_order  = "-itemPrice";
	break;
case 7: //価商品更新日時順（昇順）
	$rakuten_sort_order  = "+updateTimestamp";
	break;
case 8: //商品更新日時順（降順）
	$rakuten_sort_order  = "-updateTimestamp";
	break;
default:
	break;
}

$rwsurl = "http://api.rakuten.co.jp/rws/1.13/rest?developerId=$rakutentoken&affiliateId=$rakutenaffid&operation=ItemSearch&version=2009-02-03&keyword=$keyword&hits=10&availability=1&page=$v_page&genreId=$rakuten_category&sort=".urlencode($rakuten_sort_order);

// 改ページ用パラメータ
$params = $vcpagepage . "pagetype=rakuten&keyword=".urlencode($rakuten_keyword)."&category=".$rakuten_category."&sort=".urlencode($rakuten_sort_order);


$rwsBuff  = file_get_contents($rwsurl );
$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('itemSearch:ItemSearch', 'itemSearchItemSearch', $rwsBuff);

$xml = simplexml_load_string ($rwsBuff);
$hits = $xml->Body->itemSearchItemSearch->Items->Item;
$resultcount = h($xml->Body->itemSearchItemSearch->count);
$totalpage = h($xml->Body->itemSearchItemSearch->pageCount);

if (!$resultcount==0) {
foreach ($hits as $hit) {
$itemname[] = h($hit->itemName);
$linkurl[] = h($hit->affiliateUrl);
if (strlen($hit->mediumImageUrl)) {
	$imgurl[] = h($hit->mediumImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$price[] = h($hit->itemPrice);
$description[] = h($hit->itemCaption);
$shopname[] = h($hit->shopName);
//送料フラグ 	postageFlag 	0：送料込
//1：送料別
if ($hit->postageFlag == 0) {
	$souryou[] = "送料無料";
} else {
	$souryou[] = "送料別";
}
$reviewnum[] = h($hit->reviewCount);
$reviewavr[] = h($hit->reviewAverage);
$reviewurl[] = "";
$faviconurl[] = "";
$vcpvimg[] = "";
}

}

}

// php end 
?>

<?php
if ($_GET["pagetype"]=="jalan") {
?>
<script type="text/javascript" src="<?php echo WP_PLUGIN_URL; ?>/vc_search/area_data.js"></script>
<script type="text/javascript" src="<?php echo WP_PLUGIN_URL; ?>/vc_search/area.js"></script>
<form action="<?php echo $vcpagepage; ?>" method="get">
<input type="hidden" name="pagetype" value="<?php echo $_GET["pagetype"]; ?>" />
<select class="area_pd" name="pref" id="pref" onChange="changeLargeArea(this)"><option value="" selected>都道府県</option></select>
<select class="area_pd" name="l_area" id="l_area" onChange="changeSmallArea(this)"><option value="" selected>大エリア</option></select>
<select class="area_pd" name="s_area" id="s_area"><option value="" selected>小エリア</option></select>
<script type="text/javascript">
initAreaPulldown();
</script> 
<input type="submit" value="エリアで検索" />
 </form>
<?php
} else {
?>

<form action="<?php echo $vcpagepage; ?>" method="get">
<input type="hidden" name="pagetype" value="<?php echo $_GET["pagetype"]; ?>" />
<input type="text" name="keyword" value="<?php echo urldecode($keyword); ?>" />&nbsp;<input type="submit" value="商品検索" /><br />
<?php if (!$ysmhits=="") { ?>
絞り込みワード：
<?php foreach ($ysmhits as $hit) { ?>
<a href="<?php echo $vcpagepage; ?>keyword=<?php echo rawurlencode(h($hit)); ?>"><?php echo h($hit); ?></a>&nbsp;&nbsp;
<?php } ?>
<?php } ?><br />

<?php 
if (isset($arr_categories)) {
DrawItemSelect("category", $arr_categories, $v_category, "<option value=\"\">すべての商品");
}
if (isset($arr_sorts)) {
DrawItemSelect("sort_type", $arr_sorts, $v_sort_type, "");
}
?>
</form>

<?php
}
?>

<?php if (!urldecode($keyword)=="") { ?>
<h2><?php echo urldecode($keyword); ?>の検索結果</h2>
<?php } ?>

<p><?php echo DrawPageButton($v_page, $totalpage, $params,$resultcount); ?></p><!-- ページ切り替えボタン -->

<?php
if (!$resultcount == 0) {
foreach ($price as $key => $value) {
?>

<?php echo DrawPageItem($itemname[$key],$imgurl[$key],$linkurl[$key],$price[$key],$jancode[$key],$description[$key],$vcpvimg[$key],$guid[$key],$shopname[$key]); ?>

<?php
} //foreach

} else {
?>
<p>検索した結果、見つかりませんでした。今YAHOO!SHOPPINGで人気の急上昇キーワードで検索してみませんか？</p>
<p><?php echo kyujosho(); ?></p>
<p><?php echo vc_category(); ?></p>
<?php
}
?>

<p><?php echo DrawPageButton($v_page, $totalpage, $params,$resultcount); ?></p><!-- ページ切り替えボタン -->

<?php yahoocredit(); ?>

<?php

}


// バリューコマース商品単品表示
function vcitem_func( $atts, $content = null ) {

$vctoken= get_option('vc_search_token');
$vcpagepage= get_option('vc_search_page');

$v_keyword = $content; //表示用
$keyword = $content; //表示用
$v_keyword = urlencode(str_replace(" ", "+", trim($v_keyword))); //検索する場合は、トリムをかけて空白は「＋」で繋ぐ（AND検索）

// 並べ順の選択肢からパラメータを設定
switch ($v_sort_type) {
case 0:
	$v_sort_by = "score";
	$v_sort_order = "asc";
	break;
case 1: //価格安い順
	$v_sort_by = "price";
	$v_sort_order = "desc";
	break;
case 2: //価格高い順
	$v_sort_by = "price";
	$v_sort_order = "asc";
	break;
case 3: //今日の売れ筋順
	$v_sort_rank = "dayly";
	break;
case 4: //週間の売れ筋順
	$v_sort_rank = "weekly";
	break;
case 5: //月間の売れ筋順
	$v_sort_rank = "monthly";
	break;
default:
	break;
}


// バリューコマースリクエストURL組み立て
$vcurl = "http://webservice.valuecommerce.ne.jp/productdb/search?token=$vctoken&keyword=$v_keyword&category=$v_category&sort_by=$v_sort_by&sort_order=$v_sort_order&results_per_page=1&rank=$v_sort_rank";

// バリュコマsimpleXMLデータ取り出し配列変数に代入
 $vcBuff = file_get_contents($vcurl);

$vcBuff = str_replace('vc:', 'vc', $vcBuff);
$vcBuff = str_replace('&', '&amp;', $vcBuff);
$xml = simplexml_load_string ($vcBuff);
$hits = $xml->channel->item;

foreach ($hits as $hit) {
$itemname[] = h($hit->title);

$linkurl[] = str_replace('&amp;', '&' ,h($hit->link));

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if (strlen($img[1])) {
	$imgurl[] = h($img[1]);
} else {
	if (strlen($img[2])) {
		$imgurl[] = h($img[2]);
	} else {
	$imgurl[] = WP_PLUGIN_URL."/vc_search/c_img/noimage.gif";
	}
}

$price[] = h($hit->vcprice);
$description[] = h($hit->description);
$shopname[] = h($hit->vcmerchantName) . h($hit->vcsubStoreName);
$vcpvimg[] = $hit->vcpvImg;
$guid[] = h($hit->guid);
$jancode[] = h($hit->vcjanCode);
}
$resultcount = h($xml->channel->vcresultcount);
// 商品表示部分
// php end 
?>

<?php
if (!number_format($resultcount) == 0) {
foreach ($price as $key => $value) {
$ret ="";
$ret =DrawPageItem($itemname[$key],$imgurl[$key],$linkurl[$key],$price[$key],$jancode[$key],$description[$key],$vcpvimg[$key],$guid[$key],$shopname[$key]);
$ret =$ret .'<p><a href="'.$vcpagepage.'pagetype=vc&keyword='.$keyword.'">＞ 他のショップでも探す</a></p>';

} //foreach

} else {

$ret ='<p>&nbsp;</p>';

}
?>
<?php
return $ret;
}


// リンクシェア単品表示
function lsitem_func( $atts, $content = null ) {

$lstoken= get_option('ls_search_token');
$lspagepage= get_option('ls_search_page');
$ls_yahoo_appid= get_option('vc_yahoo_appid');

$arr_sorts = array(
	"0" => "参考価格の安い順", 
	"1" => "参考価格の高い順"
);


$vctoken= get_option('vc_search_token');
$vcpagepage= get_option('vc_search_page');

$keyword = $content; //表示用
$ls_keyword = urlencode('"'.trim($keyword).'"'); //検索する場合は、トリムをかける

// デフォルト値の設定
if(!isset($ls_page)) $ls_page = "1";
if(!isset($ls_sort_by)) $ls_sort_by = "";
if(!isset($ls_sort_order)) $ls_sort_order = "";
if(!isset($ls_sort_type)) $ls_sort_type = 0;
if(!isset($ls_page) || $ls_page == "") $ls_page = 1;
if(!isset($ls_sort_rank)) $ls_sort_rank = "";
if(!isset($ls_jancode)) $ls_jancode = "";

// 並べ順の選択肢からパラメータを設定
switch ($ls_sort_type) {
case 0:
	$ls_sort_order = "asc";
	break;
case 1: //価格安い順
	$ls_sort_order = "dsc";
	break;
default:
	break;
}


// リンクシェアリクエストURL組み立て
$lsurl = "http://feed.linksynergy.com/productsearch?token=$lstoken&keyword=$ls_keyword&max=1&pagenumber=$ls_page&sort=retailprice&sorttype=$ls_sort_order";

// 改ページ用パラメータ
$params = $lspagepage . "keyword=".urlencode($keyword)."&sort=retailprice&sorttype=$ls_sort_order";

// リンクシェアsimpleXML,データ取り出し配列変数に代入
$lsBuff = file_get_contents($lsurl);

$xml = simplexml_load_string ($lsBuff);
$hits = $xml->item;

foreach ($hits as $hit) {
if (!is_numeric(mb_strpos($hit->merchantname,"携帯"))) {
$itemname[] = h($hit->productname);
$linkurl[] = h($hit->linkurl);
if (strlen($hit->imageurl)) {
	$imgurl[] = h($hit->imageurl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->price);
$description[] = h($hit->description->short);
$shopname[] = h($hit->merchantname);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
if ($hit->merchantname == "イトーヨーカドー　ネット通販") {
	$faviconurl[] = "http://www.itoyokado.jp/";
} else {
	$faviconurl[] = h($hit->imageurl);
}

}

}  //foreach

$resultcount = h($xml->TotalMatches);
$totalpage = h($xml->TotalPages);


// 商品表示部分
// php end 
?>

<?php
if (!number_format($resultcount) == 0) {
foreach ($price as $key => $value) {
$ret ="";
$ret =DrawPageItem($itemname[$key],$imgurl[$key],$linkurl[$key],$price[$key],$jancode[$key],$description[$key],$vcpvimg[$key],$guid[$key],$shopname[$key]);
$ret =$ret .'<p><a href="'.$vcpagepage.'pagetype=ls&keyword='.$keyword.'">＞ 他のショップでも探す</a></p>';

} //foreach

} else {
$ret ='<p>&nbsp;</p>';

}
?>
<?php
return $ret;
}



// 商品検索リンク生成（バリューコマース）
function vc_func( $atts, $content = null ) {

// [vc]属性情報取得
extract(shortcode_atts(array(
'keyword' => null,
'jancode' => null,
'category' => null,
'sort_type' => null, ), $atts));

$vcpagepage= get_option('vc_search_page');
$linktext ="";


if (isset($keyword)) {
// 自由テキストリンクの場合
$keyword= urlencode($keyword);
$linkurl = $vcpagepage.'pagetype=vc&keyword='.$keyword;
} else if (isset($jancode)) {
// JANコード指定の場合※現時点ではAPIで対応していないので機能しない
$linkurl = $vcpagepage.'jancode='.$jancode;
} else {
// それ以外の[vc]で挟まれたキーワードでの検索リンクを作成する場合
$keyword= urlencode($content);
$linkurl = $vcpagepage.'pagetype=vc&keyword='.$keyword;
}

// カテゴリー指定
if (isset($category)) {
$linkurl = $linkurl."&category=". $category;
}

// ソート指定
if (isset($sort_type)) {
$linkurl = $linkurl."&sort_type=". $sort_type;
}

$linktext = '<a href="'.$linkurl.'">'.$content.'</a>';

// リンクとコンテンツを返す
return $linktext;
}


// 商品検索リンク生成(リンクシェア)
function ls_func( $atts, $content = null ) {

// [ls]属性情報取得
extract(shortcode_atts(array(
'keyword' => null,
'jancode' => null,
'category' => null,
'sort_type' => null, ), $atts));

$vcpagepage= get_option('vc_search_page');
$linktext ="";

if (isset($keyword)) {
// 自由テキストリンクの場合
$keyword= urlencode($keyword);
$linkurl = $vcpagepage.'pagetype=ls&keyword='.$keyword;
} else if (isset($jancode)) {
// JANコード指定の場合※現時点ではAPIで対応しているか調べるのは後まわし
$linkurl = $vcpagepage.'jancode='.$jancode;
} else {
// それ以外の[ls]で挟まれたキーワードでの検索リンクを作成する場合
$keyword= urlencode($content);
$linkurl = $vcpagepage.'pagetype=ls&keyword='.$keyword;
}

// カテゴリー指定
if (isset($category)) {
$linkurl = $linkurl."&category=". $category;
}

// ソート指定
if (isset($sort_type)) {
$linkurl = $linkurl."&sort_type=". $sort_type;
}

$linktext = '<a href="'.$linkurl.'">'.$content.'</a>';

// リンクとコンテンツを返す
return $linktext;
}

// 商品検索リンク生成(じゃらん)
function jalan_func( $atts, $content = null ) {

// [jalan]属性情報取得
extract(shortcode_atts(array(
'keyword' => null,
'category' => null,
'sort_type' => null, ), $atts));

$vcpagepage= get_option('vc_search_page');
$linktext ="";

if (isset($keyword)) {
// 自由テキストリンクの場合
$keyword= urlencode($keyword);
$linkurl = $vcpagepage.'pagetype=jalan&keyword='.$keyword;
} else {
// それ以外の[jalan]で挟まれたキーワードでの検索リンクを作成する場合
$keyword= urlencode($content);
$linkurl = $vcpagepage.'pagetype=jalan&keyword='.$keyword;
}

// ソート指定（未実装）
if (isset($sort_type)) {
$linkurl = $linkurl."&sort_type=". $sort_type;
}

$linktext = '<a href="'.$linkurl.'">'.$content.'</a>';

// リンクとコンテンツを返す
return $linktext;
}


// 商品検索リンク生成(楽天市場)
function rakuten_func( $atts, $content = null ) {

// [rakuten]属性情報取得
extract(shortcode_atts(array(
'keyword' => null,
'category' => null,
'sort_type' => null, ), $atts));

$vcpagepage= get_option('vc_search_page');
$linktext ="";

if (isset($keyword)) {
// 自由テキストリンクの場合
$keyword= urlencode($keyword);
$linkurl = $vcpagepage.'pagetype=rakuten&keyword='.$keyword;
} else {
// それ以外の[rakuten]で挟まれたキーワードでの検索リンクを作成する場合
$keyword= urlencode($content);
$linkurl = $vcpagepage.'pagetype=rakuten&keyword='.$keyword;
}

// カテゴリー指定
if (isset($category)) {
$linkurl = $linkurl."&category=". $category;
}

// ソート指定
if (isset($sort_type)) {
$linkurl = $linkurl."&sort_type=". $sort_type;
}

$linktext = '<a href="'.$linkurl.'">'.$content.'</a>';

// リンクとコンテンツを返す
return $linktext;
}


// 管理画面の作成

// 管理画面メニュー作成関数
function vc_search_menu() {
add_options_page('VC Search Options', 'VC Search', 8, __FILE__, 'vc_search_options');
}


// 管理画面描画
function vc_search_options() {
// ポストされた値の入力チェックと書き込み
if (isset($_POST['update_option'])) {
check_admin_referer('vc_search-options');
update_option('vc_search_token', $_POST['vc_search_token']);
update_option('vc_search_page', $_POST['vc_search_page']);
update_option('vc_yahoo_appid', $_POST['vc_yahoo_appid']);
update_option('ls_search_token', $_POST['ls_search_token']);
update_option('jalan_search_token', $_POST['jalan_search_token']);
update_option('jalan_pid', $_POST['jalan_pid']);
update_option('jalan_sid', $_POST['jalan_sid']);
update_option('rakuten_search_token', $_POST['rakuten_search_token']);
update_option('rakuten_affiliate_id', $_POST['rakuten_affiliate_id']);

update_option('custum_draw_on', $_POST['custum_draw_on']);
update_option('custum_draw_template', $_POST['custum_draw_template']);
//$this->upate_options(); ?>
<div class="updated fade"><p><strong><?php _e('Options saved.'); ?></strong></p>
</div> <?php }
$vctoken= get_option('vc_search_token');
$vcpagepage= get_option('vc_search_page');
$vc_yahoo_appid= get_option('vc_yahoo_appid');
$lstoken= get_option('ls_search_token');
$jalantoken= get_option('jalan_search_token');
$jalan_pid= get_option('jalan_pid');
$jalan_sid= get_option('jalan_sid');
$rakutentoken= get_option('rakuten_search_token');
$rakutenaffid= get_option('rakuten_affiliate_id');
$custum_draw_on=get_option('custum_draw_on');
$custum_draw_template=get_option('custum_draw_template');

?>

<div class="wrap">
<h2>VC Searchプラグイン管理画面</h2>
<p>バリューコマースから与えられたこのサイト向けのトークンを入力してください。</p>
<form name="form" method="post" action="">
<input type="hidden" name="action" value="update" />
 <?php wp_nonce_field('vc_search-options'); ?>

<table class="form-table"><tbody>
<tr>
<th><label for="vc_search_token"><?php
_e('バリューコマーストークン（token）', 'vc_search'); ?></label></th> <td><input size="36" type="text" name="vc_search_token"
id="vc_search_token" value="<?php
echo attribute_escape($vctoken); ?>" /></td>
</tr>

<tr>
<th><label for="vc_search_page"><?php
_e('[vcpage]設置ページ', 'vc_search_page'); ?></label></th> <td><input type="text" name="vc_search_page"
id="vc_search_page" value="<?php
echo attribute_escape($vcpagepage); ?>" /><br />
各種商品検索結果表示やカテゴリ一覧を表示するためのページを1ページ作成し、本文部分に“[vcpage]”を記入してください。<br />
またURLの末尾に必ず「?」（半角）を付けてください。<br />
すでに「?」がついているURLの場合は「&」(半角)をURLの末尾に必ず付けてください。</td>
</tr>

<tr>
<th><label for="vc_yahoo_appid"><?php
_e('YAHOO!JAPANアプリケーションID', 'vc_yahoo_appid'); ?></label></th> <td><input size="80" type="text" name="vc_yahoo_appid"
id="vc_search_page" value="<?php
echo attribute_escape($vc_yahoo_appid); ?>" /></td>
</tr>

<tr>
<th><label for="ls_search_token"><?php
_e('リンクシェアトークン（token）', 'ls_search'); ?></label></th> <td><input size="70" type="text" name="ls_search_token"
id="ls_search_token" value="<?php
echo attribute_escape($lstoken); ?>" /></td>
</tr>

<tr>
<th><label for="jalan_search_token"><?php
_e('じゃらんWebサービスAPIキー', 'jalan_search'); ?></label></th> <td><input type="text" name="jalan_search_token"
id="jalan_search_token" value="<?php
echo attribute_escape($jalantoken); ?>" /></td>
</tr>

<tr>
<th><label for="jalan_sid"><?php
_e('じゃらんのsid', 'jalan_sid'); ?></label></th> <td><input type="text" name="jalan_sid"
id="jalan_sid" value="<?php
echo attribute_escape($jalan_sid); ?>" /></td>
</tr>

<tr>
<th><label for="jalan_pid"><?php
_e('じゃらんのpid', 'jalan_pid'); ?></label></th> <td><input type="text" name="jalan_pid"
id="jalan_pid" value="<?php
echo attribute_escape($jalan_pid); ?>" /></td>
</tr>

<tr>
<th><label for="rakuten_affiliate_id"><?php
_e('楽天アフィリエイトID', 'rakuten_affiliate_id'); ?></label></th> <td><input size="36" type="text" name="rakuten_affiliate_id"
id="rakuten_affiliate_id" value="<?php
echo attribute_escape($rakutenaffid); ?>" /></td>
</tr>

<tr>
<th><label for="rakuten_search_token"><?php
_e('楽天デベロッパーID', 'rakuten_search_token'); ?></label></th> <td><input size="36" type="text" name="rakuten_search_token"
id="rakuten_search_token" value="<?php
echo attribute_escape($rakutentoken); ?>" /></td>
</tr>

<tr>
<th><label for="custum_draw_on"><?php
_e('カスタムデザインON/OFF', 'custum_draw_on'); ?></label></th> <td><input type="checkbox" name="custum_draw_on"
id="custum_draw_on" value="1" <?php if ($custum_draw_on==1) {echo "checked ";} ?> /></td>
</tr>

<tr>
<th><label for="custum_draw_template"><?php
_e('カスタムデザインテンプレート', 'custum_draw_template'); ?></label></th> <td>
<textarea cols="80" rows="10" name="custum_draw_template" id="custum_draw_template">
<?php echo str_replace('\\','',$custum_draw_template); ?>
</textarea> 
</td>
</tr>



</tbody></table>

<p class="submit">
<input type="submit" name="update_option" class="button- primary" value="<?php _e('Save Changes'); ?>" />
</p>

</form>
</div>

<?php
}


// プラグイン停止時にフィールドを削除
function remove_vc_search()
{
	delete_option('vc_search_token');
	delete_option('vc_search_page');
	delete_option('vc_yahoo_appid');
	delete_option('ls_search_token');
	
	delete_option('jalan_search_token');
	
	delete_option('jalan_sid');
	delete_option('jalan_pid');

	delete_option('custum_draw_on');
	delete_option('custum_draw_template');
}





// その他関数

//select name、select option配列、選択、オプション
function DrawItemSelect($name, $source_arr, $select_value, $option) {

	echo "<select name=\"$name\">$option";
	foreach($source_arr as $key => $value) {
		echo "<option value=\"$key\"";
		if ($key == $select_value) {
			echo " selected";
		}
		echo ">$value";
	}
	echo "</select>";
}

//現在ページ、総ページ数、基本パラメータ
function DrawPageButton($current_page, $pagecount, $params,$resultcount) {
if (!$resultcount==0) {
echo "検索結果" . number_format($resultcount) . "件<br />";
	if(!isset($current_page)) {
		$current_page = 1;
	}
	if($current_page > 1) {
		$page = $current_page - 1;
		echo "<a href=\"" . $params . "&page=$page\">前へ</a>&nbsp;";
	}
	if($current_page < $pagecount) {
		$page = $current_page + 1;
		echo "<a href=\"" . $params . "&page=$page\">次へ</a>";
	}
}// if number
}


// Item描画（商品表示のテンプレートはここ）
function DrawPageItem($itemname,$imgurl,$linkurl,$price,$jancode,$description,$vcpvimg,$guid,$shopname) {
$custum_draw_on=get_option('custum_draw_on');
$custum_draw_template=get_option('custum_draw_template');

if (!$custum_draw_on==1) {
// 通常テンプレートの場合
?>
<!-- 商品名（見出し） -->
<h3><?php echo $itemname; ?></h3>

<!-- 商品画像表示＆リンク -->
<div class="vc-itempic" style="background: transparent url('<?php echo $imgurl; ?>') no-repeat scroll center center; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial;"><a href="<?php echo $linkurl; ?>" target="_blank"><img src="<?php echo WP_PLUGIN_URL; ?>/vc_search/c_img/spacer.gif" class="vc-line-height" alt="" /></a></div>

<?php if (!$price == 0) { ?>
<!-- 商品情報表示 -->
参考価格：<span class="vc-price"><?php echo number_format($price); ?>円</span><br />
<?php } ?>

<?php echo mb_substr ($description,0,200,"utf-8") ?>...<br />
<a href="<?php echo $linkurl; ?>" target="_blank">この商品の詳細はこちら<?php echo $vcpvimg; ?></a><br />
<?php echo $jancode; ?><br />
<img src="http://favicon.hatena.ne.jp/?url=<?php echo urlencode($guid); ?>" /><?php echo $shopname; ?>
	
<div class="vc-pic">&nbsp;</div>
<?php
} else {
// カスタムテンプレートの場合
$custum_draw_template=str_replace('\\','',$custum_draw_template);
$custum_draw_template=str_replace('【商品名】',$itemname,$custum_draw_template);
$custum_draw_template=str_replace('【商品リンク】',$linkurl,$custum_draw_template);
$custum_draw_template=str_replace('【商品画像】',$imgurl,$custum_draw_template);
// 0円の場合の処理を後日考える
$custum_draw_template=str_replace('【参考価格】',number_format($price),$custum_draw_template);
$custum_draw_template=str_replace('【商品説明】',mb_substr ($description,0,200,"utf-8")."...",$custum_draw_template);
$custum_draw_template=str_replace('【計測イメージタグ】',$vcpvimg,$custum_draw_template);
echo $custum_draw_template;

} // if else

}


// htmlspecialchars
function h($str)
{
    return htmlspecialchars($str, ENT_QUOTES);
}

// YAHOO!SHOPPING 急上昇キーワード抽出
function kyujosho() {
$vcpagepage= get_option('vc_search_page');
$vc_yahoo_appid= get_option('vc_yahoo_appid');

// YAHOO!ショッピングリクエストURL組み立て
$ywsurl = "http://shopping.yahooapis.jp/ShoppingWebService/V1/queryRanking?appid=$vc_yahoo_appid&type=up&hits=10";
$xml = simplexml_load_file ($ywsurl);
$hits = $xml->Result->QueryRankingData;
?>
急上昇キーワード：<?php foreach ($hits as $hit) { ?>
<a href="<?php echo $vcpagepage; ?>keyword=<?php echo urlencode(h($hit->Query)); ?>"><?php echo h($hit->Query); ?></a>
<?php
	} 
}



// YAHOO!関連検索ワードリクエストURL組み立て
function kanren($keyword) {
$vc_yahoo_appid= get_option('vc_yahoo_appid');
$ysmurl = "http://search.yahooapis.jp/AssistSearchService/V1/webunitSearch?appid=$vc_yahoo_appid&query=$keyword&results=5";
$ysmBuff = file_get_contents($ysmurl);
$ysmxml = simplexml_load_string ($ysmBuff);
if ($ysmxml["totalResultsReturned"] != 0) {
	$ysmhits = $ysmxml->Result;
}
return $ysmhits;
}

// バリュコマカテゴリ検索
function vc_category() {
$vctoken= get_option('vc_search_token');
$vcpagepage= get_option('vc_search_page');

$vccurl = "http://webservice.valuecommerce.ne.jp/productdb/category?token=$vctoken&category_level=1";

// バリュコマsimpleXML,データ取り出し配列変数に代入
$vcBuff = file_get_contents($vccurl);
$vcBuff = str_replace('vc:', 'vc', $vcBuff);
$vcBuff = str_replace('&', '&amp;', $vcBuff);
$xml = simplexml_load_string ($vcBuff);
$items = $xml->channel->item;

foreach ($items as $item) {
$categoryname = h($item->title);
$categorymei = h($item->description);
echo '<h3><a href="'.$vcpagepage.'pagetype=vc&category='.$categoryname.'">' .$categorymei.'</a></h3>';
$childs = $item->vcchildCategory;
foreach ($childs as $child) {
$categoryname = h($child->title);
$categorymeic = str_replace($categorymei.',','',h($child->description));
echo '<a href="'.$vcpagepage.'pagetype=vc&category='.$categoryname.'">' .$categorymeic .'</a>&nbsp;';
}

}

}

// Yahoo Credit
function yahoocredit() {
echo  <<<EOF
<p>
<!-- Begin Yahoo! JAPAN Web Services Attribution Snippet -->
<a href="http://developer.yahoo.co.jp/about">
<img src="http://i.yimg.jp/images/yjdn/yjdn_attbtn1_125_17.gif" title="Webサービス by Yahoo! JAPAN" alt="Web Services by Yahoo! JAPAN" width="125" height="17" border="0" style="margin:15px 15px 15px 15px"></a>
<!-- End Yahoo! JAPAN Web Services Attribution Snippet -->
</p>
EOF;
}

/**
　参考：http://akabeko.sakura.ne.jp/blog/2009/12/wordpress-%E3%83%97%E3%83%A9%E3%82%B0%E3%82%A4%E3%83%B3%E3%81%A7%E3%82%A8%E3%83%87%E3%82%A3%E3%82%BF%E3%81%AB%E3%83%9C%E3%82%BF%E3%83%B3%E3%82%92%E8%BF%BD%E5%8A%A0%E3%81%99%E3%82%8B-2/
 * MCE ツールバーが初期化される時に発生します。
 */
function onMceInitButtons()
{
	// 編集権限のチェック
	if( !current_user_can( "edit_posts" ) && !current_user_can( "edit_pages" ) ) { return; }

	// ビジュアル エディタ時のみ追加
	if( get_user_option( "rich_editing" ) == "true" )
	{
		add_filter( "mce_buttons",          "onMceButtons"         );
		add_filter( "mce_external_plugins", "onMceExternalPlugins" );
	}
}

/**
 * MCE ツールバーにボタンが追加される時に発生します。
 *
 * @param	$buttons	ボタンのコレクション。
 */
function onMceButtons( $buttons )
{
	array_push( $buttons, "separator", "LS" ,"VC","RK");
	return $buttons;
}

/**
 * MCE ツールバーのボタン処理が登録される時に発生します。
 *
 * @param	$plugins	ボタンの処理のコレクション。
 */
function onMceExternalPlugins( $plugins )
{
	$pluginDirUrl = WP_PLUGIN_URL . "/" . array_pop( explode( DIRECTORY_SEPARATOR, dirname( __FILE__ ) ) ) . "/";
	$plugins[ "VCSearchButtons" ] = "{$pluginDirUrl}mce.js";
	return $plugins;
}



// WordPressプラグインとして登録するもの（ショートコードなど）

// TinyMCEアクションの登録
if( is_admin() ) {add_filter( "admin_footer", "onMceInitButtons" );}

// CSSをヘッダーに挿入
add_action('wp_head','add_vc_css');

// アイテム描画ページ
add_shortcode( 'vcpage', 'vcpage_func' );

// 検索リンク作成
add_shortcode( 'vc', 'vc_func' );
add_shortcode( 'ls', 'ls_func' );
add_shortcode( 'jalan', 'jalan_func' );
add_shortcode( 'rakuten', 'rakuten_func' );

// ブログエントリ内アイテム検索表示
add_shortcode( 'vcitem', 'vcitem_func' );
add_shortcode( 'lsitem', 'lsitem_func' );

// 管理画面、管理用
add_action('admin_menu', 'vc_search_menu');
add_action('deactivate_vc_search/vc_search.php', 'remove_vc_search');


?>