/**
 * MCE ツールバーにボタンを追加します。
 */
( function()
{
	tinymce.create( "tinymce.plugins.VCSearchButtons",
	{
		getInfo : function()
		{
			return { longname:"VC Search", author: "wackey", authorurl: "http://musilog.net/", infourl: "http://review.web-service-api.jp/", version: "1.1" };
		},

		init : function( ed, url )
		{
			var t = this;
			t.editor = ed;

			ed.addCommand( 'LS', function()
			{
				var str = "[ls][/ls]";
				ed.execCommand( "mceInsertContent", false, str );
			});
			
			ed.addCommand( 'VC', function()
			{
				var str = "[vc][/vc]";
				ed.execCommand( "mceInsertContent", false, str );
			});
			ed.addCommand( 'RK', function()
			{
				var str = "[rakuten][/rakuten]";
				ed.execCommand( "mceInsertContent", false, str );
			});

			ed.addButton( 'LS', { title: "LS", cmd: 'LS', image : url + "ls.gif" });
			ed.addButton( 'VC', { title: "VC", cmd: 'VC', image : url + "vc.gif" });
			ed.addButton( 'RK', { title: "RK", cmd: 'RK', image : url + "rk.gif" });
		},

	});

	tinymce.PluginManager.add( "VCSearchButtons", tinymce.plugins.VCSearchButtons );
} )();
